//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndDistribution.cpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndDistribution_CPP_

//======================================================================
// include
#include "RndDistribution.h"
#include "../../iris_math.h"
#include "../../iris_debug.h"

namespace iris {
namespace math {
namespace rnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDistribution::CDistribution(void)
: m_pGenerator(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	pGen	= 
*//***********************************************************************/
CDistribution::CDistribution(IRand* pGen)
: m_pGenerator(pGen)
{
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CDistribution::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	IRIS_ASSERT( m_pGenerator != nullptr );
	m_pGenerator->SetSeed(seed);
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CDistribution::GenRand32(void)
{
	IRIS_ASSERT( m_pGenerator != nullptr );
	return m_pGenerator->GenRand32();
}

/**********************************************************************//**
 *
 * @brief	Rx˂̃JCQ敪z
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= 
 * @return 
*//***********************************************************************/
f32		CDistribution::Chisq(f32 n)
{
    return 2.0f*Gamma(0.5f*n);
}

/**********************************************************************//**
 *
 * @brief	p[^̃K}z
 *
 ----------------------------------------------------------------------
 * @param [in]	a	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::Gamma(f32 a)
{
    f32 t,u,x,y;
    if(a > 1.0f)
	{
        t=sqrtf(2*a-1);
        do
		{
            do 
			{
                do 
				{
                    x=1.0f-GenFloat0_x1();
                    y=2.0f*GenFloat0_x1()-1.0f;
                } while (x*x+y*y>1);
                y /= x;
				x  = t*y+a-1;
            } while(x <= 0);
            u=(a-1)*logf(x/(a-1))-t*y;
        } while( (u < -50.0f) || (GenFloat0_x1() > (1+y*y)*exp(u) ));
    } 
	else
	{
        t=2.718281828459045235f/(a+2.718281828459045235f);
        do 
		{
            if(GenFloat0_x1() < t) 
			{
                x = powf(GenFloat0_x1(), 1.0f/a);
				y = expf(-x);
            } else 
			{
                x = 1.0f-logf(1-GenFloat0_x1());
				y = powf(x, a-1.0f);
            }
        } while(GenFloat0_x1() >= y);
    }
    return x;
}

/**********************************************************************//**
 *
 * @brief	mo̊􉽕z
 *
 ----------------------------------------------------------------------
 * @param [in]	p	= m
 * @return 
*//***********************************************************************/
s32		CDistribution::Geometric(f32 p)
{
	return (s32)(ceil(log(1.0-GenFloat0_x1())/log(1.0-p)));
}

/**********************************************************************//**
 *
 * @brief	Opz
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
f32		CDistribution::Triangle(void)
{
	return GenFloat0_1() - GenFloat0_1();
}

/**********************************************************************//**
 *
 * @brief	ςP̎wz
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
f32		CDistribution::Exp(void)
{
	return -logf(1-GenFloat0_x1());
}

/**********************************************************************//**
 *
 * @brief	WKz
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
f32		CDistribution::Normal(void)
{
	static bool sw=false;
	static f32  save=0.0f;
	if( sw ) { sw = false; return save; }

	f32 t = sqrtf(-2*logf(1.0f-GenFloat0_x1()));
	f32 u = 3.141592653589793f*2*GenFloat0_x1();
	sw = true;
    save = t*sinf(u);
	return t*cosf(u);
}

/**********************************************************************//**
 *
 * @brief	m̃_PʃxNg
 *
 ----------------------------------------------------------------------
 * @param [out]	v	= o̓obt@̐擪AhX
 * @param [in]	n	= 
*//***********************************************************************/
void		CDistribution::UnitVector(f32* v, int n)
{
    int i; f32 r=0.0f;
    for( i=0; i < n; ++i)
	{ 
		v[i] = Normal();
		r += v[i]*v[i]; 
	}
    r=sqrtf(r);
    for( i=0; i < n; ++i) v[i] /= r;
}

/**********************************************************************//**
 *
 * @brief	p[^m,ôQz
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= p[^
 * @param [in]	p	= p[^
 * @return 
*//***********************************************************************/
s32		CDistribution::Binomial(s32 n, f32 p)
{
    int i,r=0;
    for( i=0; i < n; ++i) if(GenFloat0_1() < p) ++r;
    return r;
}

/**********************************************************************//**
 *
 * @brief	֌Wq̂QϗʐKz
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= 
 * @param [out]	x	= 
 * @param [out]	y	= 
*//***********************************************************************/
void	CDistribution::Binomial(s32 r, f32* x, f32* y)
{
    f32 r1,r2,s;
    do 
	{
        r1 = 2.0f*GenFloat0_1()-1.0f;
        r2 = 2.0f*GenFloat0_1()-1.0f;
        s = r1*r1 + r2*r2;
    } while( (s > 1.0f) || (s == 0.0f) );
    s = -logf(s)/s;
	r1 = sqrtf((1+r)*s)*r1;
    r2 = sqrtf((1-r)*s)*r2;
	*x = r1+r2;
	*y = r1-r2;
}

/**********************************************************************//**
 *
 * @brief	p[^`,ãx[^z
 *
 ----------------------------------------------------------------------
 * @param [in]	a	= p[^
 * @param [in]	b	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::Beta(f32 a, f32 b)
{
	f32 temp = Gamma(a);
    return temp/(temp+Gamma(b));
}

/**********************************************************************//**
 *
 * @brief	p[^m̗ݏ敪z
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::Power(f32 n)
{
#ifdef _WIN32
    return (f32)powf(GenFloat0_1(), 1.0f/(n+1.0f));
#else
    return (f32)pow(GenFloat0_1(), 1.0f/(n+1.0f));
#endif
}

/**********************************************************************//**
 *
 * @brief	WXeBbNz
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
f32		CDistribution::Logistic(void)
{
    f32 r;
    do 
	{
		r = GenFloat0_x1(); 
	} while( r == 0.0f );
    return logf(r/(1-r));
}

/**********************************************************************//**
 *
 * @brief	R[V[z
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
f32		CDistribution::Cauchy(void)
{
    f32 x,y;
    do 
	{
		x = 1.0f-GenFloat0_1();
		y = 2.0f*GenFloat0_1()-1.0f;
	} while( (x*x+y*y) > 1.0f);
    return y/x;
}

/**********************************************************************//**
 *
 * @brief	Rx`,âez
 *
 ----------------------------------------------------------------------
 * @param [in]	a	= p[^
 * @param [in]	b	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::FDist(f32 a, f32 b)
{
    f32 ca=Chisq(a), cb = Chisq(b);
    return (ca*a)/(cb*b);
}

/**********************************************************************//**
 *
 * @brief	σɂ̃|A\z
 *
 ----------------------------------------------------------------------
 * @param [in]	lambda	= p[^
 * @return 
*//***********************************************************************/
s32		CDistribution::Poisson(f32 lambda)
{
    int k;
	lambda = expf(lambda)*GenFloat0_x1();
    for( k=0; lambda > 1; ++k) lambda *= GenFloat0_x1();
    return k;
}

/**********************************************************************//**
 *
 * @brief	Rxm̂z
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::TDist(f32 n)
{
    f32 a,b,c;
    if( n <= 2 )
	{
        do
		{
			a = Chisq(n);
		} while( a == 0.0f );
        return Normal()/sqrtf(a/n);
    }
    do
	{
        a = Normal();
		b = a*a/(n-2.0f);
        c = logf(1-GenFloat0_x1())/(1-0.5f*n);
    } while(expf(-b-c) > 1.0f-b);
    return a/sqrtf((1-2.0f/n)*(1-b));
}

/**********************************************************************//**
 *
 * @brief	p[^̃Cuz
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= p[^
 * @return 
*//***********************************************************************/
f32		CDistribution::Weibull(f32 alpha)
{
	return powf(-logf(1.0f-GenFloat0_x1()), 1.0f/alpha);
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

