//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndSTDC.cpp
 * @brief		Wrand֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndSTDC_CPP_

//======================================================================
// include
#include "RndSTDC.h"
#include <stdlib.h>

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSTDCRand::CSTDCRand(void)
{
	SetSeed(88675123);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CSTDCRand::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	::srand(seed);
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CSTDCRand::GenRand32(void)
{
	return static_cast<u32>(::rand());
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

