//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathTFpu.h
 * @brief		Zt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathTFpu_H_
#define INCG_IRIS_MathTFpu_H_

//======================================================================
// include
#include "../fpu/MathFpuDef.h"
#include "../../c++0x/type_traits/cpp0x_value_traits.hpp"
#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// declare
template<typename _TN>_TN			TFpuAbs(_TN fs);
template<typename _TN>s32			TFpuCeil(_TN fs);
template<typename _TN>s32			TFpuFloor(_TN fs);
template<typename _TN>_TN			TFpuMax(_TN a, _TN b);
template<typename _TN>_TN			TFpuMin(_TN a, _TN b);
template<typename _TN>_TN			TFpuNeg(_TN fs);
template<typename _TN>s32			TFpuRound(_TN fs);
template<typename _TN>_TN			TFpuRsqrt(_TN fs);
template<typename _TN>_TN			TFpuSqrt(_TN fs);
template<typename _TN>s32			TFpuTrunc(_TN fs);
template<typename _TN>_TN			TFpuFmod(_TN fs, _TN fd);
template<typename _TN>_TN			TFpuFrac(_TN fs);
template<typename _TN>_TN			TFpuReinterpretFloat(u32 ui);
template<typename _TN>u32			TFpuReinterpretUint(_TN fs);
template<typename _TN>IrisBool		TFpuIsEqual(_TN fs1, _TN fs2);
template<typename _TN>_TN			TFpuSignFloat(_TN fs);
template<typename _TN>s32			TFpuSignInt(_TN fs);
template<typename _TN>_TN			TFpuPositiveZero(void);
template<typename _TN>_TN			TFpuNegativeZero(void);
template<typename _TN>IrisBool		TFpuIsZero(_TN fs);
template<typename _TN>IrisBool		TFpuIsPositiveZero(_TN fs);
template<typename _TN>IrisBool		TFpuIsNegativeZero(_TN fs);
template<typename _TN>s32			TFpuIsDenormal(_TN fs);
template<typename _TN>s32			TFpuIsZeroOrDenormal(_TN fs);
template<typename _TN>_TN			TFpuPositiveInf(void);
template<typename _TN>_TN			TFpuNegativeInf(void);
template<typename _TN>s32			TFpuIsInf(_TN fs);
template<typename _TN>_TN			TFpuPositiveNaN(void);
template<typename _TN>_TN			TFpuNegativeNaN(void);
template<typename _TN>_TN			TFpuPositiveQNaN(void);
template<typename _TN>_TN			TFpuNegativeQNaN(void);
template<typename _TN>_TN			TFpuPositiveSNaN(u32 signal);
template<typename _TN>_TN			TFpuPositiveSNaNF(_TN signal);
template<typename _TN>_TN			TFpuNegativeSNaN(u32 signal);
template<typename _TN>_TN			TFpuNegativeSNaNF(_TN signal);
template<typename _TN>s32			TFpuIsNaN(_TN fs);
template<typename _TN>s32			TFpuIsInfOrNaN(_TN fs);
template<typename _TN>_TN			TFpuNormalizePhase(_TN fs);
template<typename _TN>_TN			TFpuSin(_TN fs);
template<typename _TN>_TN			TFpuCos(_TN fs);
template<typename _TN>_TN			TFpuAtan(_TN fs);
template<typename _TN>_TN			TFpuAsin(_TN fs);
template<typename _TN>_TN			TFpuAcos(_TN fs);
template<typename _TN>_TN			TFpuLog(_TN fs);
template<typename _TN>_TN			TFpuLog2(_TN fs);
template<typename _TN>_TN			TFpuLog10(_TN fs);
template<typename _TN>_TN			TFpuExp(_TN fs);
template<typename _TN>_TN			TFpuExp2(_TN fs);
template<typename _TN>_TN			TFpuExp10(_TN fs);
template<typename _TN>_TN			TFpuPow(_TN x, _TN y);
template<typename _TN>f64			TFpuCastToF64(_TN fs);
template<typename _TN>_TN			TFpuCastFromF64(f64 fs);

template<typename _TN>_TN	TFpuZero(void)			{ return TFpuPositiveZero(); }
template<typename _TN>_TN	TFpuInf(void)			{ return TFpuPositiveInf(); }
template<typename _TN>_TN	TFpuNaN(void)			{ return TFpuPositiveNaN(); }
template<typename _TN>_TN	TFpuQNaN(void)			{ return TFpuPositiveQNaN(); }
template<typename _TN>_TN	TFpuSNaN(u32 signal)	{ return TFpuPositiveSNaN(signal); }

//======================================================================
// function

/**
 * @brief	_̐ΒlԂ
 * @param [in]	fs	= l
 * @return	Βl
*/
template<typename _TN>_TN		TFpuAbs(_TN fs)
{
	return abs(fs);
}

/**
 * @brief	XJ[l̐؂グ
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>s32		TFpuCeil(_TN fs)
{
	return (s32)ceil(fs);
}

/**
 * @brief	XJ[l̐؂̂
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>s32		TFpuFloor(_TN fs)
{
	return (s32)floor(fs);
}

/**
 * @brief	XJ[ől
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ől
*/
template<typename _TN>_TN		TFpuMax(_TN a, _TN b)
{
	return (a > b) ? a : b;
}

/**
 * @brief	XJ[ŏl
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ŏl
*/
template<typename _TN>_TN		TFpuMin(_TN a, _TN b)
{
	return (a < b) ? a : b;
}

/**
 * @brief	̕Ԃ
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>_TN		TFpuNeg(_TN fs)
{
	return -fs;
}

/**
 * @brief	ߖTۂ(ľܓ)
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>s32		TFpuRound(_TN fs)
{
	return TFpuFloor(fs+0.5f);
}

/**
 * @brief	̋t
 * @param [in]	fs	= l
 * @return	̋t
*/
template<typename _TN>_TN		TFpuRsqrt(_TN fs)
{
	return cpp0x::one_traits<_TN>::value / TFpuSqrt(fs);
}

/**
 * @brief	
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>_TN		TFpuSqrt(_TN fs)
{
	return sqrt(fs);
}

/**
 * @brief	0ۂ
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>s32		TFpuTrunc(_TN fs)
{
	return (s32)fs;
}

/**
 * @brief	̏]
 * @param [in]	fs	= l
 * @param [in]	fd	= l
 * @return	]
*/
template<typename _TN>_TN		TFpuFmod(_TN fs, _TN fd)
{
	_TN v = (_TN)TFpuTrunc( fs / fd );
	return fs - v * fd;
}

/**
 * @brief	̎擾
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>_TN		TFpuFrac(_TN fs)
{
	_TN v = (_TN)TFpuTrunc(fs);
	return fs - v;
}

/**
 * @brief	^Ƃĕ]
 * @param [in]	ui	= rbgl
 * @return	
*/
template<typename _TN>_TN		TFpuReinterpretFloat(u32 ui)
{
	IrisFInt fi; fi.iv = ui;
	return fi.fv;
}

/**
 * @brief	̃rbg\Ԃ
 * @param [in]	fs	= l
 * @return	rbg
*/
template<typename _TN>u32		TFpuReinterpretUint(_TN fs)
{
	IrisFInt fi; fi.fv = fs;
	return fi.iv;
}

/**
 * @brief	_lł邩Ԃ
 * @param [in]	fs1	= l
 * @param [in]	fs2	= l
 * @return	^Ul
*/
template<typename _TN>IrisBool	TFpuIsEqual(_TN fs1, _TN fs2)
{
	return fs1 == fs2 ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	,̕_TNŕԂ
 * @param [in]	fs	= l
 * @return	,̕
*/
template<typename _TN>_TN		TFpuSignFloat(_TN fs)
{
	return (fs < cpp0x::zero_traits<_TN>::value)
		? -cpp0x::one_traits<_TN>::value
		: (fs > cpp0x::zero_traits<_TN>::value)
		? cpp0x::one_traits<_TN>::value
		: cpp0x::zero_traits<_TN>::value;
}

/**
 * @brief	,̕s32ŕԂ
 * @param [in]	fs	= l
 * @return	,̕
*/
template<typename _TN>s32		TFpuSignInt(_TN fs)
{
	return (fs < cpp0x::zero_traits<_TN>::value)
		? -cpp0x::one_traits<_TN>::value
		: (fs > cpp0x::zero_traits<_TN>::value)
		? cpp0x::one_traits<_TN>::value
		: cpp0x::zero_traits<_TN>::value;
}

/**
 * @brief	+0擾
 * @return	+0
*/
template<typename _TN>_TN		TFpuPositiveZero(void)
{
	return cpp0x::zero_traits<_TN>::value;
}

/**
 * @brief	-0擾
 * @return	-0
*/
template<typename _TN>_TN		TFpuNegativeZero(void)
{
	return -cpp0x::zero_traits<_TN>::value;
}
template<>
INLINE	f32						TFpuNegativeZero<f32>(void)
{
	IrisFInt fi; fi.iv = 0x80000000;
	return fi.fv;
}

/**
 * @brief	0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>IrisBool	TFpuIsZero(_TN fs)
{
	return fs == cpp0x::zero_traits<_TN>::value;
}
template<>
INLINE	IrisBool				TFpuIsZero<f32>(f32 fs)
{
	IrisFInt fi; fi.fv = fs;
	return (fi.iv & 0x7FFFFFFFU) == 0 ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	+0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>IrisBool	TFpuIsPositiveZero(_TN fs)
{
	return fs == cpp0x::zero_traits<_TN>::value;
}
template<>
INLINE	IrisBool				TFpuIsPositiveZero<f32>(f32 fs)
{
	IrisFInt fi; fi.fv = fs;
	return (fi.iv == 0) ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	-0ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>IrisBool	TFpuIsNegativeZero(_TN fs)
{
	return fs == -cpp0x::zero_traits<_TN>::value;
}
template<>
INLINE	IrisBool				TFpuIsNegativeZero<f32>(f32 fs)
{
	IrisFInt fi; fi.fv = fs;
	return (fi.iv == 0x80000000) ? IRIS_TRUE : IRIS_FALSE;
}

/**
 * @brief	񐳋Kł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>s32		TFpuIsDenormal(_TN fs)
{
	// TODO : 
	return 0;
}
template<>
INLINE	s32					TFpuIsDenormal<f32>(f32 fs)
{
	s32 ret = 0;
	IrisFInt fi; fi.fv = fs;
	u32 t0 = fi.iv;
	u32 t1 = t0 & 0x7F800000;
	fi.iv  = t0 | 0x7F800000;
	ret = fi.iv >> 30 ? +1 : -1;
	t0 = t0 << 9;
	ret = t1 != 0 ? 0 : ret;
	ret = t0 == 0 ? 0 : ret;
	return ret;
}

/**
 * @brief	0܂͔񐳋Kł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>s32		TFpuIsZeroOrDenormal(_TN fs)
{
	// TODO : 
	return 0;
}
template<>
INLINE	s32					TFpuIsZeroOrDenormal<f32>(f32 fs)
{
	s32 ret = 0;
	IrisFInt fi; fi.fv = fs;
	u32 t0 = fi.iv;
	u32 t1 = t0 & 0x7F800000;
	fi.iv  = t0 | 0x7F800000;
	ret = fi.iv >> 30 ? +1 : -1;
	t0 = t0 << 9;
	ret = t1 != 0 ? 0 : ret;
	return ret;
}

/**
 * @brief	+擾
 * @return	+
*/
template<typename _TN>_TN		TFpuPositiveInf(void)
{
	IRIS_ASSERT(0);
	return 0;
}
template<>
INLINE	f32						TFpuPositiveInf<f32>(void)
{
	IrisFInt fi; fi.iv = MATH_F32_P_INF_BITS;
	return fi.fv;
}

/**
 * @brief	-擾
 * @return	-
*/
template<typename _TN>_TN		TFpuNegativeInf(void)
{
	IRIS_ASSERT(0);
	return 0;
}
template<>
INLINE	f32						TFpuNegativeInf<f32>(void)
{
	IrisFInt fi; fi.iv = MATH_F32_N_INF_BITS;
	return fi.fv;
}

/**
 * @brief	ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>s32		TFpuIsInf(_TN fs)
{
	IrisFInt fi; fi.fv = fs;
	if( fi.iv == MATH_F32_P_INF_BITS ) return 1;
	if( fi.iv == MATH_F32_N_INF_BITS ) return -1;
	return 0;
}

/**
 * @brief	+NaN擾
 * @return	+NaN
*/
template<typename _TN>_TN		TFpuPositiveNaN(void)
{
	IrisFInt fi; fi.iv = MATH_F32_P_NAN_BITS;
	return fi.fv;
}

/**
 * @brief	+NaN擾
 * @return	+NaN
*/
template<typename _TN>_TN		TFpuNegativeNaN(void)
{
	IrisFInt fi; fi.iv = MATH_F32_N_NAN_BITS;
	return fi.fv;
}

/**
 * @brief	+QNaN擾
 * @return	+QNaN
*/
template<typename _TN>_TN		TFpuPositiveQNaN(void)
{
	IrisFInt fi; fi.iv = MATH_F32_P_QNAN_BITS;
	return fi.fv;
}

/**
 * @brief	-QNaN擾
 * @return	-QNaN
*/
template<typename _TN>_TN		TFpuNegativeQNaN(void)
{
	IrisFInt fi; fi.iv = MATH_F32_N_QNAN_BITS;
	return fi.fv;
}

/**
 * @brief	+SNaN擾
 * @param [in]	signal = 
 * @return	+SNaN
*/
template<typename _TN>_TN		TFpuPositiveSNaN(u32 signal)
{
	IrisFInt fi; fi.iv = MATH_F32_P_SNAN_BITS(signal);
	return fi.fv;
}

/**
 * @brief	+SNaN擾
 * @param [in]	signal = 
 * @return	+SNaN
*/
template<typename _TN>_TN		TFpuPositiveSNaNF(_TN signal)
{
	IrisFInt fi; fi.fv = signal; fi.iv = MATH_F32_N_SNAN_BITS(fi.iv);
	return fi.fv;
}

/**
 * @brief	-SNaN擾
 * @param [in]	signal = 
 * @return	-SNaN
*/
template<typename _TN>_TN		TFpuNegativeSNaN(u32 signal)
{
	IrisFInt fi; fi.iv = MATH_F32_N_SNAN_BITS(signal);
	return fi.fv;
}

/**
 * @brief	-SNaN擾
 * @param [in]	signal = 
 * @return	-SNaN
*/
template<typename _TN>_TN		TFpuNegativeSNaNF(_TN signal)
{
	IrisFInt fi; fi.fv = signal; fi.iv = MATH_F32_N_SNAN_BITS(fi.iv);
	return fi.fv;
}

/**
 * @brief	񐔂ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>s32		TFpuIsNaN(_TN fs)
{
	IrisFInt fi; fi.fv = fs;
	s32 ret = 0x807FFFFF;
	u32 t0 = fi.iv;
	u32 t1 = fi.iv << 1;
	ret = (s32)(ret & t0);
	t1 >>= 24;
	t0 <<= 9;
	t1 = (t1<0xFF);
	ret = (t0==0) ? 0 : ret;
	ret = (t1!=0) ? 0 : ret;
	return ret;
}

/**
 * @brief	or񐔂ł邩Ԃ
 * @param [in]	fs	= l
 * @return	^Ul
*/
template<typename _TN>s32		TFpuIsInfOrNaN(_TN fs)
{
	IrisFInt fi; fi.fv = fs;
	s32 ret = (s32)fi.iv;
	u32 t0 = fi.iv << 1;
	ret >>= 30;
	t0 >>= 24;
	ret |= 0x00000001;
	t0 = (t0<0xFF);
	ret = (t0!=0) ? 0 : ret;
	return ret;
}

/**
 * @brief	ʑ-΁`΂ɐK
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>_TN		TFpuNormalizePhase(_TN fs)
{
	_TN fd = fs / MATH_F32_2PI;
	s32  f0 = (s32)( fd + 0.5f );
	fd = (_TN)f0;
	fd = fd * MATH_F32_2PI;
	fd = fs - fd;
	return fd;
}

/**
 * @brief	(TC)
 * @param [in]	fs	= WAl
 * @return	
*/
template<typename _TN>_TN		TFpuSin(_TN fs)
{
	return sin(fs);
}

/**
 * @brief	](RTC)vZ
 * @param [in]	fs	= WAl
 * @return	]
*/
template<typename _TN>_TN		TFpuCos(_TN fs)
{
	return cos(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	fs	= l
 * @return	t
*/
template<typename _TN>_TN		TFpuAtan(_TN fs)
{
	return atan(fs);
}

/**
 * @brief	t(A[NTC)vZ
 * @param [in]	fs	= l
 * @return	t
*/
template<typename _TN>_TN		TFpuAsin(_TN fs)
{
	return asin(fs);
}

/**
 * @brief	t](A[NRTC)vZ
 * @param [in]	fs	= l
 * @return	t]
*/
template<typename _TN>_TN		TFpuAcos(_TN fs)
{
	return acos(fs);
}

/**
 * @brief	Rΐ
 * @param [in]	fs	= l
 * @return	Rΐ
*/
template<typename _TN>_TN		TFpuLog(_TN fs)
{
	return log(fs);
}

/**
 * @brief	2Ƃΐ
 * @param [in]	fs	= l
 * @return	2Ƃΐ
*/
template<typename _TN>_TN		TFpuLog2(_TN fs)
{
#if 1
	return log(fs) / log(2.0f);
#else
	static const _TN log2Poly[] = {
		 6051103.0f / (1024.0f * 1024.0f *  2.0f), /* arround 2.0 */
		 8065844.0f / (1024.0f * 1024.0f *  8.0f), /* arround 2.0/3.0 */
		20040025.0f / (1024.0f * 1024.0f * 32.0f), /* arround 2.0/5.0 */
	};
	union {
		_TN f;
		s32 i;
	} fi;
	s32 a, b, exponent;
	_TN y, z;
	fi.f = x;
	if(fi.i <= 0) 
	{
		if ((fi.i & 0x7fffffff) == 0) 
		{
			fi.i = 0xff800000; /* -INF */
			return fi.f;
		}
		fi.i = 0xff80ffff; /* Signaling NaN */
		return fi.f;
	}

	b = (fi.i & 0x007fffff);
	a = b - (1<<23);
	exponent = fi.i;
	if (b <= 0x3504F3)
	{
		/*J x ̉ SQRT2/2 ȉ */
		a = b;
		b = b - (1 << 23);
		exponent -= (1<<23);
	}
	b = b - (1 << 23) + (1<<25);

	x = (_TN)(a) / (_TN)(b);
	z = (_TN)((exponent>>23)-126);
	y = x * x;
	return z + x * (((log2Poly[2] * y
		+ log2Poly[1]) * y)
		+ log2Poly[0]);
#endif
}

/**
 * @brief	pΐ
 * @param [in]	fs	= l
 * @return	pΐ
*/
template<typename _TN>_TN		TFpuLog10(_TN fs)
{
	return log10(fs);
}

/**
 * @brief	eƂw
 * @param [in]	fs	= l
 * @return	eƂw
*/
template<typename _TN>_TN		TFpuExp(_TN fs)
{
	return exp(fs);
}

/**
 * @brief	2Ƃw
 * @param [in]	fs	= l
 * @return	eƂw
*/
template<typename _TN>_TN		TFpuExp2(_TN fs)
{
	return pow(2, fs);
}

/**
 * @brief	10Ƃw
 * @param [in]	fs	= l
 * @return	eƂw
*/
template<typename _TN>_TN		TFpuExp10(_TN fs)
{
	return pow(10, fs);
}

/**
 * @brief	w
 * @param [in]	x	= l
 * @param [in]	y	= l
 * @return	w
*/
template<typename _TN>_TN		TFpuPow(_TN x, _TN y)
{
	return pow(x, y);
}

/**
 * @brief	_TN  f64ɕϊ
 * @param [in]	fs	= l
 * @return	f64
*/
template<typename _TN>f64		TFpuCastToF64(_TN fs)
{
	return (f64)fs;
}

/**
 * @brief	f64  _TNɕϊ
 * @param [in]	fs	= l
 * @return	_TN
*/
template<typename _TN>_TN		TFpuCastFromF64(f64 fs)
{
	return (_TN)fs;
}


}	// end of namespace math
}	// end of namespace iris

#endif
