//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathTPerspective.h
 * @brief		Perspective t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathTPerspective_H_
#define INCG_IRIS_MathTPerspective_H_

//======================================================================
// include
#include "MathTMatrix44.h"

namespace iris {
namespace math
{

//======================================================================
// declare
template<typename _TN>IrisTMtx44<_TN>*		TFpuLookAtMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pvEye, const IrisTVec4<_TN>* pvLookAt, const IrisTVec4<_TN>* pvUp);
template<typename _TN>IrisTMtx44<_TN>*		TFpuPerspectiveMatrix(IrisTMtx44<_TN>* pm0, _TN fovy, _TN aspect, _TN xfNear, _TN xfFar);
template<typename _TN>IrisTMtx44<_TN>*		TFpuOrthoMatrix(IrisTMtx44<_TN>* pm0, _TN left, _TN top, _TN right, _TN bottom, _TN r_near, _TN r_far);
template<typename _TN>IrisTMtx44<_TN>*		TFpuFrustumMatrix(IrisTMtx44<_TN>* pm0, _TN left, _TN top, _TN right, _TN bottom, _TN r_near, _TN r_far);
template<typename _TN>IrisTMtx44<_TN>*		TFpuCameraMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv, const IrisTVec4<_TN>* pzd, const IrisTVec4<_TN>* pyd);
template<typename _TN>IrisTMtx44<_TN>*		TFpuViewScreenMatrix(IrisTMtx44<_TN>* pm0, _TN scrz, _TN ax, _TN ay, _TN cx, _TN cy
													, _TN zmin, _TN zmax, _TN nearz, _TN farz);
template<typename _TN>IrisTMtx44<_TN>*		TFpuDropShadowMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* lp, _TN a, _TN b, _TN c, int mode);
template<typename _TN>IrisTVec4<_TN>*		TFpuRotTransPers(IrisTVec4<_TN>* pv0, const IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv1);
template<typename _TN>int					TFpuRotTransPersN(short* pXyz, int pitch, const IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv0, int n);

//======================================================================
// function
/**
 * @brief	_}gbNX̐
 * @param [out]	pm0			= o̓}gbNX
 * @param [in]	pvEye		= _ʒu
 * @param [in]	pvLookAt	= _̈ʒu
 * @param [in]	pvUp		= xNg
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuLookAtMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pvEye, const IrisTVec4<_TN>* pvLookAt, const IrisTVec4<_TN>* pvUp)
{
	MATH_FPU_NULLASSERT( pm0 );
	IrisTVec4<_TN> vx, vy, vz, vtmp;
	TFpuVec4Sub(&vz, pvEye, pvLookAt);
	TFpuVec4NormalizeXYZ(&vz, &vz);
	TFpuVec4OuterProductXYZ(&vx, pvUp, &vz);
	TFpuVec4OuterProductXYZ(&vy, &vz, &vx);
	TFpuVec4NormalizeXYZ(&vx, &vx);
	TFpuVec4NormalizeXYZ(&vy, &vy);

	pm0->x.x = vx.x;
	pm0->x.y = vx.x;
	pm0->x.z = vx.x;
	pm0->x.w = 0.0f;
	pm0->y.x = vy.x;
	pm0->y.y = vy.x;
	pm0->y.z = vy.x;
	pm0->y.w = 0.0f;
	pm0->z.x = vz.x;
	pm0->z.y = vz.x;
	pm0->z.z = vz.x;
	pm0->z.w = 0.0f;
	pm0->w.x = pm0->w.y = pm0->w.z = 0.0f;
	pm0->w.w = 1.0f;

	TFpuVec4Neg(&vtmp, pvEye);
	TFpuMtx44TransformXYZ(&vtmp, pm0, &vtmp);
	vtmp.w =  1.0f;
	TFpuMtx44Transfer(pm0, pm0, &vtmp);
	return pm0;
}

/**
 * @brief	ϊs̐
 * @param [out]	pm0			= o̓}gbNX
 * @param [in]	fovy		= J̉p(WA)
 * @param [in]	aspect		= ʂ̃AXyNg(c:/c)
 * @param [in]	r_near		= ʂ̑ONbv(_̋)
 * @param [in]	r_far		= ʂ̌Nbv(_̋)
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuPerspectiveMatrix(IrisTMtx44<_TN>* pm0, _TN fovy, _TN aspect, _TN r_near, _TN r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	_TN f, asp, nf1, nf2;
	f = fovy *  0.5f;
	f = F32_Cos(f) /  F32_Sin(f);

	asp = 1.0f /  aspect;
	nf1 = 1.0f /  (r_near - r_far);
	nf2 = r_near + r_far;
	pm0->x.x = f *  asp;
	pm0->x.y = 0.0f;
	pm0->x.z = 0.0f;
	pm0->x.w = 0.0f;
	pm0->y.x = 0.0f;
	pm0->y.y = f;
	pm0->y.z = 0.0f;
	pm0->y.w = 0.0f;
	pm0->z.x = 0.0f;
	pm0->z.y = 0.0f;
	pm0->z.z = nf1 *  nf2;
	pm0->z.w = -1.0f;
	pm0->w.x = 0.0f;
	pm0->w.y = 0.0f;
	pm0->w.z =  r_near *  r_far *  nf1 * 2;
	pm0->w.w = 0.0f;
	return pm0;
}

/**
 * @brief	ˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	left	= ̐ς̍W
 * @param [in]	top		= ̐ς̏W
 * @param [in]	right	= ̐ς̉EW
 * @param [in]	bottom	= ̐ς̉W
 * @param [in]	r_near	= ̐ς̎OW
 * @param [in]	r_far	= ̐ς̉W
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuOrthoMatrix(IrisTMtx44<_TN>* pm0, _TN left, _TN top, _TN right, _TN bottom, _TN r_near, _TN r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	_TN	rl1, rl2;
	_TN	tb1, tb2;
	_TN	fn1, fn2;

	rl1 = 1.0f /  (right - left);
	rl2 = right + left;
	tb1 = 1.0f /  (top - bottom);
	tb2 = top + bottom;
	fn1 = 1.0f /  (r_far - r_near);
	fn2 = r_far + r_near;

	pm0->x.x = 2.0f *  rl1;
	pm0->x.y = 0.0f;
	pm0->x.z = 0.0f;
	pm0->x.w = 0.0f;
	pm0->y.x = 0.0f;
	pm0->y.y = 2.0f *  tb1;
	pm0->y.z = 0.0f;
	pm0->y.w = 0.0f;
	pm0->z.x = 0.0f;
	pm0->z.y = 0.0f;
	pm0->z.z = -2.0f *  fn1;
	pm0->z.w = 0.0f;
	pm0->w.x = -1.0f *  rl2 *  rl1;
	pm0->w.y = -1.0f *  tb2 *  tb1;
	pm0->w.z = -1.0f *  fn2 *  fn1;
	pm0->w.w = 1.0f;
	return pm0;
}

/**
 * @brief	ˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	left	= ̐ς̍W
 * @param [in]	top		= ̐ς̏W
 * @param [in]	right	= ̐ς̉EW
 * @param [in]	bottom	= ̐ς̉W
 * @param [in]	r_near	= ̐ς̎OW
 * @param [in]	r_far	= ̐ς̉W
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuFrustumMatrix(IrisTMtx44<_TN>* pm0, _TN left, _TN top, _TN right, _TN bottom, _TN r_near, _TN r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	pm0->x.x =   2.0f *  r_near /   (right - left );
	pm0->x.y =  0.0f;
	pm0->x.z =  0.0f;
	pm0->x.w =  0.0f;
	pm0->y.x =  0.0f;
	pm0->y.y =   2.0f *  r_near /  (top - bottom );
	pm0->y.z =  0.0f;
	pm0->y.w =  0.0f;
	pm0->z.x =  (right + left)	 /  (right - left);
	pm0->z.y =  (top   + bottom)	 /  (top   - bottom);
	pm0->z.z = -(r_far + r_near)	 /  (r_far - r_near);
	pm0->z.w = -1.0f;
	pm0->w.x =  0.0f;
	pm0->w.y =  0.0f;
	pm0->w.z = -  2.0f *  r_far *  r_near /  (r_far - r_near );
	pm0->w.w =  0.0f;
	return pm0;
}

/**
 * @brief	[hr[s̐
 * @note	_pv(0,0,0)ɁApzd(0,0,1)ɁApyd(0,1,0)ɂƕϊ悤ȍs߁Apm0ɕԂ܂B
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	pv		= ̐ς̍W
 * @param [in]	pzd		= _}gbNX
 * @param [in]	pyd		= }gbNX
 * @param [in]	bottom	= 
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuCameraMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv, const IrisTVec4<_TN>* pzd, const IrisTVec4<_TN>* pyd)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv );
	MATH_FPU_NULLASSERT( pzd );
	MATH_FPU_NULLASSERT( pyd );
	IrisTMtx44<_TN> fm;
	IrisTVec4<_TN> xd;
	TFpuMtx44Unit(&fm);
	TFpuVec4OuterProductXYZ(&xd, pyd, pzd);
	TFpuVec4NormalizeXYZ(&fm.x, &xd);
	TFpuVec4NormalizeXYZ(&fm.z, pzd);
	TFpuVec4OuterProductXYZ(&fm.y, &fm.z, &fm.x);
	TFpuMtx44Transfer(&fm, &fm, pv);
	TFpuMtx44Inverse(pm0, &fm);
	return pm0;
}

/**
 * @brief	r[XN[s̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	scrz	= XN[܂ł̋
 * @param [in]	ax		= XAXyNg
 * @param [in]	ay		= YAXyNg
 * @param [in]	cx		= XN[̒SXW
 * @param [in]	cy		= XN[̒SYW
 * @param [in]	zmin	= Zobt@ŏl
 * @param [in]	zmax	= Zobt@ől
 * @param [in]	nearz	= jANbvʂZ
 * @param [in]	farz	= t@[NbvʂZ
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuViewScreenMatrix(IrisTMtx44<_TN>* pm0, _TN scrz, _TN ax, _TN ay, _TN cx, _TN cy
													, _TN zmin, _TN zmax, _TN nearz, _TN farz)
{
	MATH_FPU_NULLASSERT( pm0 );
	IrisTMtx44<_TN> mt;
	_TN cz =  ( -zmax *  nearz + zmin *  farz ) /  (-nearz + farz);
	_TN az =   farz *  nearz *  (-zmin + zmax ) /  (-nearz + farz);
	TFpuMtx44Unit(pm0);
	pm0->x.x = scrz;
	pm0->y.y = scrz;
	pm0->z.z = 0.0f;
	pm0->w.w = 0.0f;
	pm0->w.z = 1.0f;
	pm0->z.w = 1.0f;

	TFpuMtx44Unit(&mt);
	mt.x.x = ax;
	mt.y.y = ay;
	mt.z.z = az;
	mt.w.x = cx;
	mt.w.y = cy;
	mt.w.z = cz;

	TFpuMtx44Mul(pm0, &mt, pm0);
	return pm0;
}

/**
 * @brief	hbvVhEˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	lp		= ̈ʒu
 * @param [in]	a		= e̓e
 * @param [in]	b		= e̓e
 * @param [in]	c		= e̓e
 * @param [in]	mode	= ̎(0: s 1: _)
 * @return	o̓}gbNX
*/
template<typename _TN>IrisTMtx44<_TN>*	TFpuDropShadowMatrix(IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* lp, _TN a, _TN b, _TN c, int mode)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( lp );
	if( mode )
	{
		// spot light
		_TN x = lp->x, y = lp->y, z = lp->z;
		_TN d = 1.0f - (a *  x + b *  y + c *  z);

		pm0->x.x = a *  x+d;
		pm0->y.x = b *  x;
		pm0->z.x = c *  x;
		pm0->w.x = -x;
		pm0->x.y = a *  y;
		pm0->y.y = b *  y+d;
		pm0->z.y = c *  y;
		pm0->w.y = -y;
		pm0->x.z = a *  z;
		pm0->y.z = b *  z;
		pm0->z.z = c *  z+d;
		pm0->w.z = -z;
		pm0->x.w = a;
		pm0->y.w = b;
		pm0->z.w = c;
		pm0->w.w = d - 1.0f;
	}
	else
	{
		// parallel light
		_TN p  = lp->x, q = lp->y, r = lp->z;
		_TN n  = a *  p + b *  q + c *  r;
		_TN nr = -1.0f /  n;

		pm0->x.x = nr *  a *  p-n;
		pm0->y.x = nr *  b *  p;
		pm0->z.x = nr *  c *  p;
		pm0->w.x = nr *  (-p);
		pm0->x.y = nr *  a *  q;
		pm0->y.y = nr *  b *  q-n;
		pm0->z.y = nr *  c *  q;
		pm0->w.y = nr *  (-q);
		pm0->x.z = nr *  a *  r;
		pm0->y.z = nr *  b *  r;
		pm0->z.z = nr *  c *  r-n;
		pm0->w.z = nr *  (-r);
		pm0->x.w = 0.0f;
		pm0->y.w = 0.0f;
		pm0->z.w = 0.0f;
		pm0->w.w = nr *  (-n);
	}
	return pm0;
}

/**
 * @brief	ϊ
 * @param [out]	pv0		= o̓xNg
 * @param [in]	pm0		= }gbNX
 * @param [in]	pv1		= 
 * @return	o̓xNg
*/
template<typename _TN>IrisTVec4<_TN>*		TFpuRotTransPers(IrisTVec4<_TN>* pv0, const IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv1)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	_TN x, y, z, w, q;

	x = pm0->x.x *  pv1->x + pm0->y.x *  pv1->y + pm0->z.x *  pv1->z + pm0->w.x *  pv1->w;
	y = pm0->x.y *  pv1->x + pm0->y.y *  pv1->y + pm0->z.y *  pv1->z + pm0->w.y *  pv1->w;
	z = pm0->x.z *  pv1->x + pm0->y.z *  pv1->y + pm0->z.z *  pv1->z + pm0->w.z *  pv1->w;
	w = pm0->x.w *  pv1->x + pm0->y.w *  pv1->y + pm0->z.w *  pv1->z + pm0->w.w *  pv1->w;
	q = 1.0f /  w;

	pv0->x = x *  q;
	pv0->y = y *  q;
	pv0->z = z *  q;
	pv0->w = q;
	return pv0;
}

/**
 * @brief	^ꂽn̒_XN[Wɓϊ
 * @param [out]	pXyz	= o̓obt@
 * @param [in]	pitch	= o̓obt@sb`
 * @param [in]	pm0		= }gbNX
 * @param [in]	pv0		= _z
 * @param [in]	n		= _zTCY
*/
template<typename _TN>int				TFpuRotTransPersN(short* pXyz, int pitch, const IrisTMtx44<_TN>* pm0, const IrisTVec4<_TN>* pv0, int n)
{
	MATH_FPU_NULLASSERT( pXyz );
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv0 );
	for( int i=0; i < n; ++i )
	{
		_TN x, y, z, w, q;
		x = pm0->x.x *  pv0[i].x + pm0->y.x *  pv0[i].y + pm0->z.x *  pv0[i].z + pm0->w.x *  pv0[i].w;
		y = pm0->x.y *  pv0[i].x + pm0->y.y *  pv0[i].y + pm0->z.y *  pv0[i].z + pm0->w.y *  pv0[i].w;
		z = pm0->x.z *  pv0[i].x + pm0->y.z *  pv0[i].y + pm0->z.z *  pv0[i].z + pm0->w.z *  pv0[i].w;
		w = pm0->x.w *  pv0[i].x + pm0->y.w *  pv0[i].y + pm0->z.w *  pv0[i].z + pm0->w.w *  pv0[i].w;
		q = 1.0f /  w;

		pXyz[0] = (short)( x *  q );
		pXyz[1] = (short)( y *  q );
		pXyz[2] = (short)( z *  q );
		pXyz = (short*)(void*)((char*)pXyz + pitch);
	}
	return 0;
}

}	// end of namespace math
}	// end of namespace iris

#endif
