//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathTPlane.h
 * @brief		ʉZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathTPlane_H_
#define INCG_IRIS_MathTPlane_H_

//======================================================================
// include
#include "../fpu/MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
template<typename _TN>IrisTPlane<_TN>*		TFpuPlaneSet(IrisTPlane<_TN>* pl0, _TN a, _TN b, _TN c, _TN d);
template<typename _TN>IrisTPlane<_TN>*		TFpuPlaneCopy(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1);
template<typename _TN>IrisTPlane<_TN>*		TFpuPlaneAdd(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1, const IrisTPlane<_TN>* pl2);
template<typename _TN>IrisTPlane<_TN>*		TFpuPlaneSub(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1, const IrisTPlane<_TN>* pl2);
template<typename _TN>IrisTPlane<_TN>*		TFpuPlaneNormalize(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1);
template<typename _TN>_TN					TFpuPlaneVec3Distance(const IrisTPlane<_TN>* pl0, const IrisFVec3* pv0);
template<typename _TN>_TN					TFpuPlaneVec4DistanceXYZ(const IrisTPlane<_TN>* pl0, const IrisFVec4* pv0);


//======================================================================
// function
/**
 * @brief	ʂ̐
 * @param [out]	pl0	= o͕
 * @param [in]	a	= vfa
 * @param [in]	b	= vfb
 * @param [in]	c	= vfc
 * @param [in]	d	= vfd
 * @return	o͕
*/
template<typename _TN> IrisTPlane<_TN>*	TFpuPlaneSet(IrisTPlane<_TN>* pl0, _TN a, _TN b, _TN c, _TN d)
{
	MATH_FPU_NULLASSERT( pl0 );
	pl0->a = a;
	pl0->b = b;
	pl0->c = c;
	pl0->d = d;
	return pl0;
}

/**
 * @brief	ʂ̃Rs[
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
template<typename _TN> IrisTPlane<_TN>*	TFpuPlaneCopy(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	pl0->a = pl1->a;
	pl0->b = pl1->b;
	pl0->c = pl1->c;
	pl0->d = pl1->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̉Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 
 * @param [in]	pl2	= 
 * @return	o͕
*/
template<typename _TN> IrisTPlane<_TN>*	TFpuPlaneAdd(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1, const IrisTPlane<_TN>* pl2)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	MATH_FPU_NULLASSERT( pl2 );
	pl0->a = pl1->a + pl2->a;
	pl0->b = pl1->b + pl2->b;
	pl0->c = pl1->c + pl2->c;
	pl0->d = pl1->d + pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̌Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 팸
 * @param [in]	pl2	= 
 * @return	o͕
*/
template<typename _TN> IrisTPlane<_TN>*	TFpuPlaneSub(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1, const IrisTPlane<_TN>* pl2)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	MATH_FPU_NULLASSERT( pl2 );
	pl0->a = pl1->a - pl2->a;
	pl0->b = pl1->b - pl2->b;
	pl0->c = pl1->c - pl2->c;
	pl0->d = pl1->d - pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̖@1ɂȂ悤ɐK
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
template<typename _TN> IrisTPlane<_TN>*	TFpuPlaneNormalize(IrisTPlane<_TN>* pl0, const IrisTPlane<_TN>* pl1)
{
	_TN a = pl1->a;
	_TN b = pl1->b;
	_TN c = pl1->c;
	_TN d = pl1->d;
	f64 q = 1.0 / F64_Sqrt(a * a + b * b + c * c);
	if(q!=0.0) q = 1.0 / q;

	pl0->a = a * q;
	pl0->b = b * q;
	pl0->c = c * q;
	pl0->d = d * q;
	return pl0;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
template<typename _TN> _TN			TFpuPlaneVec3Distance(const IrisTPlane<_TN>* pl0, const IrisFVec3* pv0)
{
	f64 n = F64_Sqrt(pl0->a * pl0->a + pl0->b * pl0->b + pl0->c * pl0->c);
	f64 f = F64_Abs( (pl0->a * pv0->x + pl0->b * pv0->y + pl0->c * pv0->z + pl0->d) / n);
	return (_TN)f;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
template<typename _TN> _TN			TFpuPlaneVec4DistanceXYZ(const IrisTPlane<_TN>* pl0, const IrisFVec4* pv0)
{
	f64 n = F64_Sqrt(pl0->a * pl0->a + pl0->b * pl0->b + pl0->c * pl0->c);
	f64 f = F64_Abs( (pl0->a * pv0->x + pl0->b * pv0->y + pl0->c * pv0->z + pl0->d) / n);
	return (_TN)f;
}


}	// end of namespace math
}	// end of namespace iris

#endif
