//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_mul.hpp
 * @brief		iris meta language operator t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_mul_HPP_
#define INCG_IRIS_iml_mul_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"

namespace iml
{

//======================================================================
// class
/**
 * @brief	|Z
*/
template<intmax_t V1, intmax_t V2>
class static_mul
{
	template<intmax_t T1, intmax_t T2, typename DMY>
	struct mul_impl 
	{
		static const intmax_t value = T1 * T2;
	};
	template<intmax_t T1, typename DMY>
	struct mul_impl<T1, 0, DMY>
	{
		static const intmax_t value = 0;
	};
	template<intmax_t T2, typename DMY>
	struct mul_impl<0, T2, DMY>
	{
		static const intmax_t value = 0;
	};
	template<typename DMY>
	struct mul_impl<0, 0, DMY>
	{
		static const intmax_t value = 0;
	};
public:
	static const intmax_t value = mul_impl<V1, V2, void>::value;
};

}	// end of namespace iml

#endif
