//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_shift.hpp
 * @brief		iris meta language operator t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_shift_HPP_
#define INCG_IRIS_iml_shift_HPP_

//======================================================================
// include
#include "iml_abs.hpp"
#include "iml_sign.hpp"

namespace iml
{

//======================================================================
// class
/**
 * @brief	tVtg萔
*/
template<intmax_t V, intmax_t S>
class static_lshift
{
	template<intmax_t TV, intmax_t TS, intmax_t SIGN=static_sign<TS>::value>
	struct shift_impl 
	{
		static const intmax_t value = TV << TS;
	};
	template<intmax_t TV, intmax_t TS>
	struct shift_impl<TV, TS, -1>
	{
		static const intmax_t value = TV >> static_abs<TS>::value;
	};
public:
	static const intmax_t value = shift_impl<V, S>::value;
};

/**
 * @brief	tEVtg萔
*/
template<intmax_t V, intmax_t S>
class static_rshift
{
	template<intmax_t TV, intmax_t TS, intmax_t SIGN=static_sign<TS>::value>
	struct shift_impl 
	{
		static const intmax_t value = TV >> TS;
	};
	template<intmax_t TV, intmax_t TS>
	struct shift_impl<TV, TS, -1>
	{
		static const intmax_t value = TV << static_abs<TS>::value;
	};
public:
	static const intmax_t value = shift_impl<V, S>::value;
};

/**
 * @brief	tVtg
*/
template<typename TN, intmax_t SHIFT>
class signed_lshift
{
	template<intmax_t TS, intmax_t SIGN=static_sign<TS>::value>
	struct shift_impl 
	{
		static TN	shift(TN v)	{ return v << TS; }
	};
	template<intmax_t TS>
	struct shift_impl<TS, -1>
	{
		static TN	shift(TN v)	{ return v >> static_abs<TS>::value; }
	};
public:
	static TN	shift(TN v) { return shift_impl<SHIFT>::shift(v); }
};

/**
 * @brief	tEVtg
*/
template<typename TN, intmax_t SHIFT>
class signed_rshift
{
	template<intmax_t TS, intmax_t SIGN=static_sign<TS>::value>
	struct shift_impl 
	{
		static TN	shift(TN v)	{ return v >> TS; }
	};
	template<intmax_t TS>
	struct shift_impl<TS, -1>
	{
		static TN	shift(TN v)	{ return v << static_abs<TS>::value; }
	};
public:
	static TN	shift(TN v) { return shift_impl<SHIFT>::shift(v); }
};

}	// end of namespace iml

#endif
