//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_op_eq.hpp
 * @brief		iris meta language operator equal t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD Limlnse is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_op_eq_HPP_
#define INCG_IRIS_iml_op_eq_HPP_

//======================================================================
// include
#include "../detail/iml_detail.hpp"

namespace iml
{

//======================================================================
// declare
template<int b1, int b2>struct op_eq;
template<int b1, int b2>struct op_ne;

//======================================================================
// class
/// iml equal
template<int b1, int b2>
struct op_eq
{
	enum { value = (b1 == b2) };
};

/// iml ne
template<int b1, int b2>
struct op_ne
{
	enum { value = (b1 != b2) };
};

}	// end of namespace iml

#endif
