//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkRefObj.h
 * @brief		Havok Reference Object t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkRefObj_H_
#define INCG_IRIS_HvkRefObj_H_

//======================================================================
// include
#include "hvk_inchead.h"
#include "../../fnd/container/FndLiberator.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include "Common/Base/hkBase.h"
#include "Common/Base/Memory/Router/hkMemoryRouter.h"

namespace iris {
namespace havok
{

//======================================================================
// class
/**
 * @brief	Havok Reference Object NX
 * @tparam _TC = Havok Reference Object ^
*/
template<class _TC, class _Liberator=fnd::CLiberatorObject<_TC> >
class CRefObj : public _Liberator
{
	typedef CRefObj<_TC, _Liberator>	_Myt;
public:
	typedef _Liberator	Liberator;
	typedef _TC			value_type;
	typedef _TC			*value_ptr;
	typedef _TC			&value_ref;
public:
	/// RXgN^
	CRefObj(void) {}
	/// Rs[RXgN^
	CRefObj(const _Myt& obj)
	{
		if( obj.ptr() != nullptr )
		{
			m_ptr = obj.ptr();
			ptr()->addReference();
		}
	}
	/// fXgN^
	virtual ~CRefObj(void)			{ Delete(); }

public:
	operator value_ptr (void)		{ return ptr(); }
	value_ptr	operator -> (void)	{ return ptr(); }
public:
	/// 폜
	virtual void Delete(void)
	{
		if( m_ptr != nullptr )
		{
			value_ptr p = ptr();
			p->removeReference();
			if( p->getReferenceCount() < 1 )
				this->liberate();
			m_ptr = nullptr;
		}
	}
};


}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
