//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkSystem.cpp
 * @brief		Havok AP[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkSystem_CPP_

//======================================================================
// include
#include "HvkSystem.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_HAVOK

#include <Common/Base/keycode.cxx>
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>

//======================================================================
// link
#pragma comment	(lib, "hkBase.lib")

namespace iris {
namespace havok
{

//======================================================================
// declare
void _hvkErrorReportFunction(const char* s, void* errorReportObject);

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHavokSystem::CHavokSystem(void)
: m_pRouter(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHavokSystem::~CHavokSystem(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
bool CHavokSystem::Initialize(void)
{
	if( m_pRouter != nullptr ) return true;
	m_pRouter = hkMemoryInitUtil::initDefault();
	if( m_pRouter == nullptr ) return false;
	hkBaseSystem::init(m_pRouter, _hvkErrorReportFunction);
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CHavokSystem::Terminate(void)
{
	hkBaseSystem::quit();
	hkMemoryInitUtil::quit();
	m_pRouter = nullptr;
}

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * G[|[gR[obN
 *
*//***********************************************************************/
void _hvkErrorReportFunction(const char* s, void* errorReportObject)
{
	IRIS_WARNING(s);
}



}	// end of namespace havok
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "iris_using.h"
#include <stdio.h>

//======================================================================
// declare
UNITTEST_MAIN_FUNC(HvkSystemUnitTest);

//======================================================================
// class
class CHvkSystemUnitTest : public iris::unit::CUnitTest<CHvkSystemUnitTest> {};

// `
IRIS_UNITTEST(CHvkSystemUnitTest, HvkSystemUnitTest);

//======================================================================
// typedef
typedef CHvkSystemUnitTest	dbUnitTest;

/**********************************************************************//**
 *
 * UNITTEST_MAIN
 * 
 ----------------------------------------------------------------------
 * @return
*//***********************************************************************/
UNITTEST_MAIN_FUNC(HvkSystemUnitTest)
{
	CHavokSystem system;
	system.Initialize();
	return 0;
}

#endif

#endif
