//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkBoxShape.cpp
 * @brief		Havok BoxShape t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkBoxShape_CPP_

//======================================================================
// include
#include "HvkBoxShape.h"


#ifdef _IRIS_SUPPORT_HAVOK

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CBoxShape::CBoxShape(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CBoxShape::~CBoxShape(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= x̒
 * @param [in]	y	= y̒
 * @param [in]	z	= z̒
 * @retrun	
*//***********************************************************************/
bool CBoxShape::Create(hkReal x, hkReal y, hkReal z)
{
	return Create(hkVector4(x, y, z));
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	halfExtents	= {bNX̊exNg̒
 * @retrun	
*//***********************************************************************/
bool CBoxShape::Create(const hkVector4& halfExtents)
{
	Delete();
	m_ptr = new hkpBoxShape(halfExtents);
	if( m_ptr == nullptr ) return false;
	return true;
}

}	// end of namespace havok
}	// end of namespace iris

#endif
