//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkCylinderShape.h
 * @brief		Havok CylinderShape t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkCylinderShape_H_
#define INCG_IRIS_HvkCylinderShape_H_

//======================================================================
// include
#include "HvkShape.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include "Physics/Collide/Shape/Convex/Cylinder/hkpCylinderShape.h"

namespace iris {
namespace havok
{

//======================================================================
// class
/// Shape NXC^[tFCX
class CCylinderShape : public IShape
{
public:
	// RXgN^
	CCylinderShape(void);
	// fXgN^
	virtual ~CCylinderShape(void);

public:
	// 쐬
	bool	Create(const hkVector4& vertexA,const hkVector4& vertexB, hkReal radius, hkReal paddingRadius = hkConvexShapeDefaultRadius);
};


}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
