//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		STMBootloader.h
 * @brief		STMBootloader t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_STMBootloader_H_
#define INCG_IRIS_STMBootloader_H_

//======================================================================
// include

#if	defined(__cplusplus)
extern "C" {
#endif

//======================================================================
// typedef
typedef unsigned char	stm32cmd_t;	//!< R}ȟ^
typedef void			*STM32PORT;	//!< |[gnh
#if	!defined(BOOL)
typedef int	BOOL;
#endif

//======================================================================
// define
#ifndef TRUE
#  define TRUE	1
#endif
#ifndef FALSE
#  define FALSE	0
#endif

// dll support
#ifndef	DLL_EXPORT
#  if	defined(_WIN32) && defined(STM32DLL)
#    if		defined(_USRDLL)
#      define DLL_EXPORT	__declspec(dllexport)
#    else
#      define DLL_EXPORT	__declspec(dllimport)
#    endif
#  else
#    define DLL_EXPORT		
#  endif
#endif
#ifndef	DLL_IMPORT
#  if	defined(_WIN32) && defined(STM32DLL)
#    if		defined(_USRDLL)
#      define DLL_IMPORT	__declspec(dllimport)
#    else
#      define DLL_IMPORT	__declspec(dllexport)
#    endif
#  else
#    define DLL_IMPORT
#  endif
#endif

// R}h
#define STM32BL_CMD_GET				0x00	//!< get command
#define STM32BL_CMD_GETVER			0x01	//!< get version & protection status command
#define STM32BL_CMD_GETID			0x02	//!< get id command
#define STM32BL_CMD_READ_MEMORY		0x11	//!< read memory command
#define STM32BL_CMD_GO				0x21	//!< go command
#define STM32BL_CMD_WRITE_MEMORY	0x31	//!< write memory command
#define STM32BL_CMD_ERASE_MEMORY	0x43	//!< erase memory command
#define STM32BL_CMD_EXTENDED_ERASE	0x44	//!< extended erase memory command

#define STM32BL_CMD_WRITE_PROTECT		0x63	//!< write protect command
#define STM32BL_CMD_WRITE_UNPROTECT		0x73	//!< write unprotect command
#define STM32BL_CMD_READOUT_PROTECT		0x82	//!< readout protect command
#define STM32BL_CMD_READOUT_UNPROTECT	0x92	//!< readout unprotect command


//======================================================================
// extern
// M֐
extern int stm32_bootloader_write(STM32PORT port, const char* buf, int size);
// M֐
extern int stm32_bootloader_read(STM32PORT port, char* buf, int size);
// u[No
extern int stm32_bootloader_break(STM32PORT port);

//======================================================================
// function

// 1byte 
DLL_EXPORT	BOOL	stm32_bootloader_write_byte(STM32PORT port, unsigned char value);
// ԐM҂
DLL_EXPORT	BOOL	stm32_bootloader_wait_ack(STM32PORT port);
// ڑ֐
DLL_EXPORT	BOOL	stm32_bootloader_connect(STM32PORT port);
// R}hM
DLL_EXPORT	BOOL	stm32_bootloader_command(STM32PORT port, stm32cmd_t cmd);

// get
DLL_EXPORT	BOOL	stm32_bootloader_get(STM32PORT port);
// `bvID̎擾
DLL_EXPORT	BOOL	stm32_bootloader_get_id(STM32PORT port, void* pid, unsigned int size);
// `bvID̃obt@TCY擾
DLL_EXPORT	BOOL	stm32_bootloader_get_id_size(STM32PORT port, int* n);
// get version & protection status
DLL_EXPORT	BOOL	stm32_bootloader_get_ver(STM32PORT port, int* pver, int* opbyte);
// read memory
DLL_EXPORT	BOOL	stm32_bootloader_read_memory(STM32PORT port, void* dst, unsigned int address, unsigned int size);
// go
DLL_EXPORT	BOOL	stm32_bootloader_go(STM32PORT port, unsigned int address);
// write memory
DLL_EXPORT	BOOL	stm32_bootloader_write_memory(STM32PORT port, const void* src, unsigned int address, unsigned int size);
// verify
DLL_EXPORT	BOOL	stm32_bootloader_verify(STM32PORT port, const void* src, unsigned int address, unsigned int size);

// erase memory
DLL_EXPORT	BOOL	stm32_bootloader_erase_memory_pages(STM32PORT port, unsigned char pagenum, char* pages);
// erase memory
DLL_EXPORT	BOOL	stm32_bootloader_erase_memory_page(STM32PORT port, char page);
// erase memory
DLL_EXPORT	BOOL	stm32_bootloader_erase_memory_all(STM32PORT port);
// extended erase memory
DLL_EXPORT	BOOL	stm32_bootloader_extended_erase_memory(STM32PORT port, unsigned short pagenum, short* pages);

// write protect
DLL_EXPORT	BOOL	stm32_bootloader_write_protect(STM32PORT port, stm32cmd_t* sectors, unsigned char size);
// write unprotect
DLL_EXPORT	BOOL	stm32_bootloader_write_unprotect(STM32PORT port);
// readout protect
DLL_EXPORT	BOOL	stm32_bootloader_readout_protect(STM32PORT port);
// readout unprotect
DLL_EXPORT	BOOL	stm32_bootloader_readout_unprotect(STM32PORT port);


#if	defined(__cplusplus)
}
#endif

#endif
