//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXError.h
 * @brief		DirectXG[R[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXError_H_
#define INCG_IRIS_DXError_H_

//======================================================================
// include
#include "dx_inchead.h"
#include "../win/debug/WXDebug.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)
#  include <d3dmxerr.h>
#endif
#if defined(_IRIS_DX_SUPPORT_DXERR)
#  if !defined(_IRIS_SUPPORT_DXMOBILE)
#    include <dxerr.h>
#  endif
#endif

//======================================================================
// function
namespace iris {
namespace dx
{
// G[擾
extern void DXFormatMessage (HRESULT hr, LPTSTR lpBuf, size_t size);
extern void DXFormatMessageA(HRESULT hr, LPSTR  lpBuf, size_t size);
extern void DXFormatMessageW(HRESULT hr, LPWSTR lpBuf, size_t size);
}	// end of namespace dx
}	// end of namespace iris

//======================================================================
// define

#ifdef _IRIS_DEBUG

#define DX_ERROR(hResult)				do { if( FAILED(hResult) ) { TCHAR err_str[256]; iris::dx::DXFormatMessage(hResult, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define DX_ERROR2(hResult, comm)		do { if( FAILED(hResult) ) { TCHAR err_str[256]; iris::dx::DXFormatMessage(hResult, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define DX_CHECK_RESULT(exp)			do { HRESULT hResult = (exp); if( FAILED(hResult) ) {				\
											TCHAR err_str[256]; iris::dx::DXFormatMessage(hResult, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
										} } while(0)
#define DX_DO_CHECK_RESULT(exp, todo)	do { HRESULT hResult = (exp); if( FAILED(hResult) ) {				\
											TCHAR err_str[256]; iris::dx::DXFormatMessage(hResult, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
										} } while(0)

#else

#define DX_ERROR(hResult)				(void)(0)
#define DX_ERROR2(hResult,comm)			(void)(0)
#define DX_CHECK_RESULT(exp)			exp
#define DX_DO_CHECK_RESULT(exp, todo)	do { if( FAILED(exp) ) { todo; } } while(0)

#endif

#endif
