//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXObject.h
 * @brief		DirectXfoCXIuWF̃x[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXObject_H_
#define INCG_IRIS_DXObject_H_

//======================================================================
// include
#include "../dx_inchead.h"
#include "fnd/types/FndExecutor.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXDevice;
class IDXSwapChain;
class IDXMtxObject;

//======================================================================
// class

//======================================================================
//! ׂĂDXObject̊NX 
class IDXGXObject : public fnd::CExecutor, public INonCopyable<IDXGXObject>
{
	friend class CDXDevice;		//!< @ref	iris::dx::CDXDevice		@note ǗNX̃ANZX
	friend class IDXSwapChain;	//!< @ref	iris::dx::IDXSwapChain
private:
	CDXDevice*			m_pDevice;		//!< foCXǗ
	IDXSwapChain*		m_pSwapChain;	//!< Xbv`FC
public:
	// RXgN^
	IDXGXObject(void);
	// fXgN^
	virtual ~IDXGXObject(void);
public:
	//! 쐬
	virtual bool	Create(void) = 0;
	//! XV
	virtual void	Update(f32 time) = 0;
	//! `O
	virtual	void	PreDraw(void)	{}
	//! `
	virtual	void	Draw(void) = 0;
	//! `㏈
	virtual	void	PostDraw(void)	{}
	//! 
	virtual	void	Release(void) = 0;

protected:
	//! Zbg
	virtual	void	Reset(void) = 0;
	//! XgA
	virtual	void	Restore(void) = 0;

public:
	//! [h}gbNX̐ݒ
	virtual	void			SetWorldMatrix(LPD3DXMATRIX /*pmat*/)	{}
	//! [h}gbNX̎擾
	virtual	LPD3DXMATRIX	GetWorldMatrix(void)					{ return nullptr; }

	//! [hW̐ݒ
	virtual	void			SetWorldPos(const D3DXVECTOR3* /*pos*/)	{}

public:
	CDXDevice*						GetDXDevice(void)			{ return m_pDevice; }
	CDXDevice*						GetDXDevice(void) const		{ return m_pDevice; }
	IDXSwapChain*					GetDXSwapChain(void)		{ return m_pSwapChain; }
	IDXSwapChain*					GetDXSwapChain(void) const	{ return m_pSwapChain; }
	// wrap
	CDXDeviceX&						GetDeviceX(void)	const;
	LPCDXDEVICE						GetDevice(void)		const;
	LPCDXPRESENT_PARAMETERS const	GetPresent(void)	const;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXSPRITE						GetSprite(void)		const;
#endif

private:
	// foCX̓o^
	void	SetDevice(CDXDevice* pDevice, IDXSwapChain* pSwapChain);
};

//======================================================================
//! }gbNXtDXObject
class IDXMtxObject : virtual public IDXGXObject
{
protected:
	D3DXMATRIX			m_Mtx;	//!< }gbNX
public:
	/// RXgN^
	IDXMtxObject(void)
		: m_Mtx(D3DXMATRIX(	 1.0f,0.0f,0.0f,0.0f
							,0.0f,1.0f,0.0f,0.0f
							,0.0f,0.0f,1.0f,0.0f
							,0.0f,0.0f,0.0f,1.0f))
	{}
	/// fXgN^
	//virtual ~IDXMtxObject(void) {}
public:
	// set,get
	virtual	void			SetWorldMatrix(LPD3DXMATRIX pmat)	{ m_Mtx = *pmat; }
	virtual	LPD3DXMATRIX	GetWorldMatrix(void)				{ return &m_Mtx; }

	virtual	void		SetWorldPos(const D3DXVECTOR3* pos)	{ m_Mtx._41 = pos->x; m_Mtx._42 = pos->y; m_Mtx._43 = pos->z; }
	virtual	void		GetWorldPos(	  D3DXVECTOR3* pos)	{ pos->x = m_Mtx._41; pos->y = m_Mtx._42; pos->z = m_Mtx._43; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
