//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXObjectManager.cpp
 * @brief		DirectXfoCXǗ(@\g)t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXObjectManager_CPP_

//======================================================================
// include
#include "DXObjectManager.h"
#include "../DXError.h"

#include "../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	rSwapChain	= CDXSwapChainCX^X
*//***********************************************************************/
CDXObjectManager::CDXObjectManager(IDXSwapChain* pSwapChain)
: m_pSwapChain(pSwapChain)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXObjectManager::~CDXObjectManager()
{
	Release();
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
 * @return	
*//***********************************************************************/
bool CDXObjectManager::DeleteObject(IDXGXObject* obj)
{
	for( vecObj::iterator it = m_newObj.begin(), end = m_newObj.end(); it != end; ++it )
	{
		if( obj == *it )
		{
			it = m_newObj.erase(it);
			delete obj;
			break;
		}
	}
	return true;
}
/**********************************************************************//**
 *
 * IuWFNg̑S폜
 *
*//***********************************************************************/
void CDXObjectManager::DeleteObjectAll(void)
{
	for( vecObj::iterator it = m_newObj.begin(); it != m_newObj.end(); )
	{
		IDXGXObject* obj = *it;
		it = m_newObj.erase(it);
		delete obj;
	}
}

/**********************************************************************//**
 *
 * IuWFNg̍폜 + C[IuWFNg폜
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @param [in]	obj		= IuWFNg
 * @return	
*//***********************************************************************/
bool CDXObjectManager::EraseLayerObject(int LayerID, IDXGXObject* obj)
{
	for( vecObj::iterator it = m_newObj.begin(), end = m_newObj.end(); it != end; ++it )
	{
		if( obj == *it )
		{
			m_pSwapChain->EraseObject(LayerID,obj);
			it = m_newObj.erase(it);
			delete obj;
			break;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @return	
*//***********************************************************************/
bool CDXObjectManager::DeleteLayer(int LayerID)
{
	if( !m_pSwapChain->EraseLayer(LayerID) ) return false;
	for( vecLayer::iterator it = m_newLayer.begin(), end = m_newLayer.end(); it != end; ++it )
	{
		IDXLayer* layer = *it;
		if( layer->GetLayerID() == LayerID )
		{
			m_newLayer.erase(it);
			delete layer;
			break;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	layer	= C[
 * @return	
*//***********************************************************************/
bool CDXObjectManager::DeleteLayer(IDXLayer* layer)
{
	if( !m_pSwapChain->EraseLayer(layer) ) return false;
	for( vecLayer::iterator it = m_newLayer.begin(), end = m_newLayer.end(); it != end; ++it )
	{
		if( layer == *it )
		{
			m_newLayer.erase(it);
			delete layer;
			break;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * C[̑S폜
 *
*//***********************************************************************/
void CDXObjectManager::DeleteLayerAll(void)
{
	for( vecLayer::iterator it = m_newLayer.begin(); it != m_newLayer.end(); )
	{
		IDXLayer* layer = *it;
		it = m_newLayer.erase(it);
		delete layer;
	}
	m_pSwapChain->EraseLayerAll();
}

}	// end of namespace dx
}	// end of namespace iris
