//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSwapChain.cpp
 * @brief		Xbv`FCNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXSwapChain_CPP_

//======================================================================
// include
#include "DXSwapChain.h"
#include "DXDevice.h"
#include "../DXError.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
// IDXSwapChain
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXSwapChain::IDXSwapChain(void)
: m_pDxSwapChain(nullptr)
, m_pBackBuffer(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXSwapChain::~IDXSwapChain(void)
{
	m_pSwapChain = nullptr;
	DX_SAFE_RELEASE(m_pBackBuffer);
	DX_SAFE_RELEASE(m_pDxSwapChain);
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void IDXSwapChain::Update(f32 time)
{
	m_Layer.Update(time);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void IDXSwapChain::Release(void)
{
	DX_SAFE_RELEASE(m_pBackBuffer);
	DX_SAFE_RELEASE(m_pDxSwapChain);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void IDXSwapChain::Draw(void)
{
	m_Layer.Draw();
}

/**********************************************************************//**
 *
 * `Jn
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= NAJ[
 * @param [in]	backbuffer	= trueȂD3DCLEAR_TARGET
 * @param [in]	zbuffer		= trueȂD3DCLEAR_ZBUFFER
 * @return	
*//***********************************************************************/
bool IDXSwapChain::BeginScene(D3DCOLOR color, bool backbuffer, bool zbuffer)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	//if( !::IsWindowVisible(m_hWnd) ) return false;
	if( !::IsWindowEnabled(GetHWND()) ) return false;
	return pDxDevice->BeginScene(color, backbuffer, zbuffer);
}

/**********************************************************************//**
 *
 * `I
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @param [in]	hDestWindowOverride	= ]EBhEnh
 * @return	
*//***********************************************************************/
bool IDXSwapChain::EndScene(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	return pDxDevice->EndScene();
}

/**********************************************************************//**
 *
 * ]
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @param [in]	hDestWindowOverride	= ]EBhEnh
 * @return	
*//***********************************************************************/
bool IDXSwapChain::Present(const RECT* pSrcRect)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	if( pDxDevice->IsState(CDXDevice::DXDS_DEVICE_LOST) ) return false;
	HWND hWnd = GetHWND();
	HRESULT hr;
	if( m_pDxSwapChain == nullptr )
	{
		hr = GetDevice()->Present(pSrcRect, nullptr, hWnd, nullptr);
	}
	else
	{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
		hr = m_pDxSwapChain->Present(pSrcRect, nullptr, hWnd, nullptr, 0);
#else
		hr = m_pDxSwapChain->Present(pSrcRect, nullptr, hWnd, nullptr);
#endif
	}
	switch(hr)
	{
	case D3DERR_DEVICELOST:
		pDxDevice->EnableState(CDXDevice::DXDS_DEVICE_LOST);
		return false;
	case D3DERR_INVALIDCALL:
		IRIS_WARNING("failed Device->Present.");
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * ]
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @param [in]	hDestWindowOverride	= ]EBhEnh
 * @return	
*//***********************************************************************/
bool IDXSwapChain::PresentOverride(const RECT* pSrcRect, HWND hDestWindowOverride)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	if( pDxDevice->IsState(CDXDevice::DXDS_DEVICE_LOST) ) return false;
	HRESULT hr;
	if( m_pDxSwapChain == nullptr )
	{
		hr = GetDevice()->Present(pSrcRect, nullptr, hDestWindowOverride, nullptr);
	}
	else
	{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
		hr = m_pDxSwapChain->Present(pSrcRect, nullptr, hDestWindowOverride, nullptr, 0);
#else
		hr = m_pDxSwapChain->Present(pSrcRect, nullptr, hDestWindowOverride, nullptr);
#endif
	}
	switch(hr)
	{
	case D3DERR_DEVICELOST:
		pDxDevice->EnableState(CDXDevice::DXDS_DEVICE_LOST);
		return false;
	case D3DERR_INVALIDCALL:
		IRIS_WARNING("failed Device->Present.");
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * IuWFNg̐
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
 * @return	
*//***********************************************************************/
bool IDXSwapChain::RegisterDeviceObject(IDXGXObject* obj)
{
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return false;
	if( obj == nullptr || m_pDevice == nullptr ) return false;
	if( obj->GetDXDevice() != nullptr ) return true;
	obj->SetDevice(pDxDevice, this);
	if( !obj->Create() ) return false;
	m_Objects.push_back(obj);
	return true;
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
 * @return	
*//***********************************************************************/
bool IDXSwapChain::EraseDeviceObject(IDXGXObject* obj)
{
	if( obj != nullptr )
	{
		for( vecObj::iterator it = m_Objects.begin(); it != m_Objects.end(); ++it )
		{
			if( *it == obj )
			{
				obj->SetDevice(nullptr, nullptr);
				m_Objects.erase(it);
				return true;
			}
		}
	}
	return false;
}

/**********************************************************************//**
 *
 * IuWFNgC[狭폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
*//***********************************************************************/
void IDXSwapChain::EraseLayerObjectForce(IDXGXObject* obj)
{
	m_Layer.EraseLayerObjectForce(obj);
}

/**********************************************************************//**
 *
 * C[̒ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @param [in]	layer	= C[NX
 * @return	
*//***********************************************************************/
bool IDXSwapChain::RegisterLayer(int LayerID, IDXLayer* layer)
{
	return m_Layer.RegisterLayer(LayerID, layer, this);
}

/**********************************************************************//**
 *
 * EBhEnh̎擾
 *
 ----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND IDXSwapChain::GetHWND(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return nullptr;
	return pDxDevice->GetHWND();
}

/**********************************************************************//**
 *
 * LPCDXPRESENT_PARAMETERS̎擾
 *
 ----------------------------------------------------------------------
 * @return	LPCDXPRESENT_PARAMETERS
*//***********************************************************************/
LPCDXPRESENT_PARAMETERS const IDXSwapChain::GetPresent(void) const
{
	const CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return nullptr;
	return pDxDevice->GetPresent();
}

/**********************************************************************//**
 *
 * obNobt@HDC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	phdc	= óBHDC̃|C^
 * @return	
*//***********************************************************************/
HRESULT IDXSwapChain::GetDC(HDC* phdc)
{
	if( m_pBackBuffer == nullptr ) return S_FALSE;
	return ( m_pBackBuffer->GetDC(phdc) );
}

/**********************************************************************//**
 *
 * obNobt@HDCԋp
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc	= HDC
 * @return	
*//***********************************************************************/
HRESULT IDXSwapChain::ReleaseDC(HDC hdc)
{
	if( m_pBackBuffer == nullptr ) return S_FALSE;
	return ( m_pBackBuffer->ReleaseDC(hdc) );
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void IDXSwapChain::Reset(void)
{
	// o^IuWFNg̃Zbg
	for( vecObj::iterator it = m_Objects.begin(), end = m_Objects.end(); it != end; ++it )
	{
		(*it)->Reset();
	}
	Release();
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void IDXSwapChain::Restore(void)
{
	// o^IuWFNg̃Zbg
	for( vecObj::iterator it = m_Objects.begin(), end = m_Objects.end(); it != end; ++it )
	{
		(*it)->Restore();
	}
	Create();
}


// CDXDefaultSwapChain
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXDefaultSwapChain::CDXDefaultSwapChain(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXDefaultSwapChain::~CDXDefaultSwapChain(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXDefaultSwapChain::Create(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	LPCDXDEVICE pDevice = GetDevice();
	if( pDevice == nullptr ) return false;
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	DX_DO_CHECK_RESULT( pDevice->CreateAdditionalSwapChain(pDxDevice->GetPresent(), &m_pDxSwapChain), return false );
#else
	DX_DO_CHECK_RESULT( pDevice->GetSwapChain(0, &m_pDxSwapChain), return false );
#endif
	m_pDxSwapChain->GetBackBuffer(0, D3DBACKBUFFER_TYPE_MONO, &m_pBackBuffer);
	return true;
}

/**********************************************************************//**
 *
 * foCXXV
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= EBhE
 * @param [in]	height	= EBhE
 * @return	
*//***********************************************************************/
bool CDXDefaultSwapChain::ReSize(UINT width, UINT height)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	return pDxDevice->ReSize(width, height);
}

// CDXSwapChain
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXSwapChain::CDXSwapChain(void)
: m_hWnd(nullptr)
, m_pStencil(nullptr)
, m_pPreSurface(nullptr)
, m_pPreStencil(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXSwapChain::~CDXSwapChain(void)
{
	DX_SAFE_RELEASE(m_pStencil);
	CDXDeviceX pDevice = GetDevice();
	if( m_pPreSurface != nullptr )
	{
		if( pDevice != nullptr )
			pDevice.SetRenderTarget(0, m_pPreSurface);
		DX_SAFE_RELEASE(m_pPreSurface);
	}
	if( m_pPreStencil != nullptr )
	{
		if( pDevice != nullptr )
			pDevice.SetDepthStencilSurface(m_pPreStencil);
		DX_SAFE_RELEASE(m_pPreStencil);
	}
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXSwapChain::Initialize(HWND hWnd, UINT width, UINT height)
{
	m_Present.BackBufferWidth	= width;
	m_Present.BackBufferHeight	= height;
	m_hWnd = hWnd;
	return true;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXSwapChain::Create(void)
{
	if( m_hWnd == nullptr ) return false;
	CDXDevice* pDxDevice = GetDXDevice();
	CDXDeviceX pDevice = GetDevice();
	IRIS_ASSERT( pDevice != nullptr );
	UINT w = m_Present.BackBufferWidth;
	UINT h = m_Present.BackBufferHeight;
	m_Present = *pDxDevice->GetPresent();
	m_Present.BackBufferWidth	= w;
	m_Present.BackBufferHeight	= h;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	m_Present.hDeviceWindow	= m_hWnd;
#endif
	DX_DO_CHECK_RESULT(pDevice->CreateAdditionalSwapChain(&m_Present, &m_pDxSwapChain), return false);
	// XeVobt@
	DX_DO_CHECK_RESULT(pDevice.CreateDepthStencilSurface(w, h, m_Present.AutoDepthStencilFormat
		, D3DMULTISAMPLE_NONE, 0, 0, &m_pStencil, nullptr ), return false);
	m_pDxSwapChain->GetBackBuffer(0, D3DBACKBUFFER_TYPE_MONO, &m_pBackBuffer);
	return true;
}

/**********************************************************************//**
 *
 * foCXXV
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= EBhE
 * @param [in]	height	= EBhE
 * @return	
*//***********************************************************************/
bool CDXSwapChain::ReSize(UINT width, UINT height)
{
	if( width == 0 || height == 0 ) return false;
	if( m_Present.BackBufferWidth == width
		&& m_Present.BackBufferHeight == height ) return true;
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return false;

	m_Present.BackBufferWidth = width;
	m_Present.BackBufferHeight= height;
	Reset();
	Restore();
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXSwapChain::Release(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( m_pPreSurface != nullptr )
	{
		if( pDevice != nullptr )
			pDevice.SetRenderTarget(0, m_pPreSurface);
		DX_SAFE_RELEASE(m_pPreSurface);
	}
	if( m_pPreStencil != nullptr )
	{
		if( pDevice != nullptr )
			pDevice.SetDepthStencilSurface(m_pPreStencil);
		DX_SAFE_RELEASE(m_pPreStencil);
	}
	IDXSwapChain::Release();
	DX_SAFE_RELEASE(m_pStencil);
}

/**********************************************************************//**
 *
 * `Jn
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= NAJ[
 * @param [in]	backbuffer	= trueȂD3DCLEAR_TARGET
 * @param [in]	zbuffer		= trueȂD3DCLEAR_ZBUFFER
 * @return	
*//***********************************************************************/
bool CDXSwapChain::BeginScene(D3DCOLOR color, bool backbuffer, bool zbuffer)
{
	CDXDevice* pDxDevice = GetDXDevice();
	CDXDeviceX pDevice = GetDevice();
	IRIS_ASSERT( pDevice != nullptr );
	IRIS_ASSERT( m_pPreSurface == nullptr );
	IRIS_ASSERT( m_pPreStencil == nullptr );
	//if( !::IsWindowVisible(m_hWnd) ) return false;
	if( !::IsWindowEnabled(m_hWnd) ) return false;
	pDevice.GetRenderTarget(0, &m_pPreSurface);
	pDevice.GetDepthStencilSurface(&m_pPreStencil);

#if 0
	bool ret = pDxDevice.BeginScene();
	pDevice.SetRenderTarget(0, m_pBackBuffer);
	pDevice.SetDepthStencilSurface(m_pStencil);
	//eNX`T[tFCX̃NA
	pDevice.Clear( 0, nullptr, 
		D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
		color, 1.0f, 0 );
	return ret;
#else
	pDevice.SetRenderTarget(0, m_pBackBuffer);
	pDevice.SetDepthStencilSurface(m_pStencil);
	if( !pDxDevice->BeginScene(color, backbuffer, zbuffer) )
	{
		pDevice.SetRenderTarget(0, m_pPreSurface);
		pDevice.SetDepthStencilSurface(m_pPreStencil);
		DX_SAFE_RELEASE(m_pPreSurface);
		DX_SAFE_RELEASE(m_pPreStencil);
		return false;
	}
	return true;
#endif
}

/**********************************************************************//**
 *
 * `I
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @param [in]	hDestWindowOverride	= ]EBhEnh
 * @return	
*//***********************************************************************/
bool CDXSwapChain::EndScene(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	CDXDeviceX pDevice = GetDevice();
	IRIS_ASSERT( pDevice != nullptr );
	pDevice.SetRenderTarget(0, m_pPreSurface);
	pDevice.SetDepthStencilSurface(m_pPreStencil);
	DX_SAFE_RELEASE(m_pPreSurface);
	DX_SAFE_RELEASE(m_pPreStencil);
	return pDxDevice->EndScene();
}

}	// end of namespace dx
}	// end of namespace iris
