//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGammaRamp.h
 * @brief		directX K}vt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXGammaRamp_H_
#define INCG_IRIS_DXGammaRamp_H_

//======================================================================
// include
#include "../DXObject.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace dx
{

//======================================================================
// typedef
/// gammaȐ֐
typedef WORD	(*PFN_DXGammaCurve)(WORD gamma, int index);

//======================================================================
// function
WORD DXGammaCurveLiner(WORD gamma, int index);

//======================================================================
// declare

//======================================================================
// class
//! K}vNX
class CDXGammaRamp : virtual public IDXGXObject
{
protected:
	D3DGAMMARAMP	m_Gamma;	//!< K}v\
public:
	// RXgN^
	CDXGammaRamp(void);
	// fXgN^
	virtual ~CDXGammaRamp(void);
public:
	// 쐬
	virtual bool	Create(void) { return true; }
public:
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);
public:
	// K
	virtual void	Activate(void);

public:
	// set
	// K}lݒ
	virtual	void	SetGamma(WORD gamma, PFN_DXGammaCurve func);

protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
