//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFont.h
 * @brief		directX ltHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFont_H_
#define INCG_IRIS_DXFont_H_

//======================================================================
// include
#include "DXFontInfo.h"
#include "../texture/DXTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXFont;

//======================================================================
// class
//! tHgNXC^[tFCX
class IDXFont : public CDXTexture
{
protected:
	intr::DXICOLOR	m_ClearColor;	//!< NAJ[
	intr::DXICOLOR	m_FontColor;	//!< F
	int				m_FontWidth;	//!< tHg
	int				m_FontHeight;	//!< tHg

public:
	// RXgN^
	IDXFont(void);
	// fXgN^
	virtual ~IDXFont(void);

public:
	// eNX`쐬
	virtual bool	Create(UINT width, UINT height) = 0;
public:
	// ̈̃NA
	virtual void	Clear(void)	= 0;
	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA( int x, int y, LPCSTR  pString, size_t size ) = 0;
	virtual bool	TextOutW( int x, int y, LPCWSTR pString, size_t size ) = 0;

public:
	// tHg쐬
	// 쐬ۂɃtHg̕ƍXV邱
	// łɍ쐬ς݂̏ꍇ́AfalseԂ
	virtual	bool	CreateFontA( int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName) = 0;
	virtual	bool	CreateFontW( int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName) = 0;
	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) = 0;
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) = 0;
#ifdef UNICODE
	bool	CreateFontFromInfo( const CDXFontInfo* lpInfo ) { return CreateFontFromInfoW(lpInfo); }
#else
	bool	CreateFontFromInfo( const CDXFontInfo* lpInfo ) { return CreateFontFromInfoA(lpInfo); }
#endif // !UNICODE

	// tHg폜
	virtual	void	DeleteFont(void) = 0;

protected:
	// Zbg
	virtual	void	Reset(void)		{}
	// XgA
	virtual	void	Restore(void)	{}

public:
	// NAJ[
	void			SetClearColor(const intr::DXICOLOR& color)	{ m_ClearColor = color; }
	intr::DXICOLOR	GetClearColor(void)							{ return m_ClearColor; }

	// tHgJ[
	void			SetFontColor(const intr::DXICOLOR& color)	{ m_FontColor = color; }
	intr::DXICOLOR	GetFontColor(void)							{ return m_FontColor; }

	// tHg̕擾
	int				GetFontWidth(void)						{ return m_FontWidth; }
	// tHg̍擾
	int				GetFontHeight(void)						{ return m_FontHeight; }

private:
	// B
	virtual bool	CreateTexture(UINT, UINT, UINT, DWORD, D3DFORMAT, D3DPOOL)	{ return false; }
	virtual	bool	Load(LPCSTR path, intr::DXICOLOR remColor=0xFF000000, UINT width=0, UINT height=0, UINT mipmaplevel=1, DWORD usage=0
							, DWORD filter = D3DX_FILTER_NONE, DWORD mipFilter=D3DX_DEFAULT
							, DXIMAGE_INFO* srcInfo=nullptr, PALETTEENTRY* pltEntry=nullptr) 
	{
		IRIS_UNUSED_VARIABLE(path);			IRIS_UNUSED_VARIABLE(remColor);		IRIS_UNUSED_VARIABLE(width);
		IRIS_UNUSED_VARIABLE(height);		IRIS_UNUSED_VARIABLE(mipmaplevel);	IRIS_UNUSED_VARIABLE(usage);
		IRIS_UNUSED_VARIABLE(filter);		IRIS_UNUSED_VARIABLE(mipFilter);	IRIS_UNUSED_VARIABLE(srcInfo);
		IRIS_UNUSED_VARIABLE(pltEntry);
		return false; 
	}
public:
	// }`oCgR[hɕϊ
	static int		mbtocode(LPCSTR mb, UINT& code)
	{ 
			if(IsDBCSLeadByte(*mb))	{ code = (BYTE)mb[0]<<8 | (BYTE)mb[1]; return 2; }
			else					{ code = mb[0]; return 1; }
	}
};

#if	!defined(_IRIS_SUPPORT_DXMOBILE)

/**
 * @brief	D3DXFONTNX
 * @note	foCXZbgɃeLXgݒ肵Ȃ΂ȂȂB
*/
class CDXFont : public IDXFont
{
protected:
	LPDXSURFACE	m_pStencil;	//!< XeVobt@
	LPDXFONT	m_pFont;	//!< tHg
	DWORD		m_Format;	//!< tH[}bg

public:
	// RXgN^
	CDXFont(void);
	// fXgN^
	~CDXFont(void);

public:
	virtual bool	Create(UINT width, UINT height);
	// 
	virtual void	Release(void);

public:
	// ̈̃NA
	virtual void	Clear(void);

	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size);
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size);

	// `
	virtual bool	TextOutDirectA(int x1, int y1, int x2, int y2, LPCSTR  pString, size_t size);
	virtual bool	TextOutDirectW(int x1, int y1, int x2, int y2, LPCWSTR pString, size_t size);
public:
	// tHg쐬
	virtual	bool	CreateFontA( int height, int width, int weight, DWORD bItalic, DWORD /*bUnderline*/, DWORD /*bStrikeOut*/
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName)
	{
		return CreateFontA( height, width, weight, 1, bItalic
			, iCharSet, iOutputPrecision, iQuality, iPitchAndFamily, pszFaceName );
	}
	virtual	bool	CreateFontW( int height, int width, int weight, DWORD bItalic, DWORD /*bUnderline*/, DWORD /*bStrikeOut*/
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName)
	{
		return CreateFontW( height, width, weight, 1, bItalic
			, iCharSet, iOutputPrecision, iQuality, iPitchAndFamily, pszFaceName );
	}

	virtual	bool CreateFontA( int height, int width, UINT weight, UINT MipLevel
					, BOOL Italic, DWORD CharSet, DWORD OutputPrecision, DWORD Quality, DWORD PitchAndFamily
					, LPCSTR pszFaceName);
	virtual	bool CreateFontW( int height, int width, UINT weight, UINT MipLevel
					, BOOL Italic, DWORD CharSet, DWORD OutputPrecision, DWORD Quality, DWORD PitchAndFamily
					, LPCWSTR pszFaceName);
	virtual bool CreateFontIndirectA( const DXFONT_DESCA* lplf );
	virtual bool CreateFontIndirectW( const DXFONT_DESCW* lplf );

	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) { DXFONT_DESCA fd; lpInfo->GetFontDescaA(fd); return CreateFontIndirectA(&fd); }
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) { DXFONT_DESCW fd; lpInfo->GetFontDescaW(fd); return CreateFontIndirectW(&fd); }

	// tHg폜
	virtual void	DeleteFont(void);

protected:
	// Zbg
	virtual void Reset(void);
	// XgA
	virtual void Restore(void);
};

#endif

}	// end of namespace dx
}	// end of namespace iris

#endif
