//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGdiFont.cpp
 * @brief		directX GDI gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXGdiFont_CPP_

//======================================================================
// include
#include "DXGdiFont.h"
#include "../DXDevice.h"
#include "../../DXError.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXGdiFont::CDXGdiFont(void)
: m_hFont(nullptr)
, m_hDC(nullptr)
, m_bAntialias(true)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXGdiFont::~CDXGdiFont(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ̈̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool CDXGdiFont::Create(UINT width, UINT height)
{
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( !CDXTexture::CreateTexture(width, height, 1, D3DMUSAGE_LOCKABLE, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM) )
#endif
	{
		if( !CDXTexture::CreateTexture(width, height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED) )
		{
			return false;
		}
	}
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	DX_DO_CHECK_RESULT( m_pTexture->GetSurfaceLevel(0, &m_pSurface), return false );
#else
	IRIS_ASSERT( GetDXDevice() );
	DX_DO_CHECK_RESULT( GetDXDevice()->GetDevice()->CreateOffscreenPlainSurface(width, height, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, &m_pSurface, nullptr), return false);
#endif
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXGdiFont::Release(void)
{
	CDXTexture::Release();
	DeleteFont();
}

/**********************************************************************//**
 *
 * ̈̃NA
 * 
*//***********************************************************************/
void CDXGdiFont::Clear(void)
{
	if( m_pTexture == nullptr ) return;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) { DX_ERROR( hr ); return; }

	memset(TexRect.pBits, 0x00, TexRect.Pitch*m_Height);
	m_pTexture->UnlockRect( 0 );
}

/**********************************************************************//**
 *
 * `
 * 
 ----------------------------------------------------------------------
 * @param [in]	x, y			= `ʒu
 * @param [in]	pString			= 
 * @param [in]	size			= 
 * @return	
*//***********************************************************************/
bool CDXGdiFont::TextOutA(int x, int y, LPCSTR  pString, size_t size)
{
	if( m_hFont == nullptr )
	{
		IRIS_WARNING( "HFONT is nullptr." );
		return false;
	}
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr || m_pTexture == nullptr || m_pSurface == nullptr ) return false;

	HDC hDC = m_hDC;
	LPDXSURFACE pSurface = nullptr;
	do
	{
		if( hDC == nullptr )
		{
			HRESULT hr = m_pSurface->GetDC(&hDC);
			if( SUCCEEDED(hr) )
			{
				m_hDC = hDC;
				pSurface = m_pSurface;
				break;
			}
			DX_ERROR(hr);
		}

#if	defined(_IRIS_SUPPORT_DXMOBILE)
		if( FAILED(pDxDevice->GetDevice()->CreateImageSurface(m_Width, m_Height, D3DFMT_A8R8G8B8, &pSurface)) ) return false;
		if( FAILED(pSurface->GetDC(&hDC)) ) return false;
#else
		return false;
#endif	
	} while(0);

	HBRUSH brush = (HBRUSH)CreateSolidBrush(0xff000000);

	// hԂ
	RECT rc;
	GetRect(&rc);
	FillRect(hDC, &rc, brush); 
	
	// F
	SetTextColor(hDC, 0xffffffff);
	int bkMode = SetBkMode(hDC, TRANSPARENT);	// wil
	
	// `
	DrawTextA(hDC, pString, size, &rc, 0);

	SetBkMode(hDC, bkMode);

	pSurface->ReleaseDC(hDC);
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( pSurface != m_pSurface )
	{
		pDxDevice->GetDevice()->CopyRects(pSurface, nullptr, 0, m_pSurface, nullptr);
		pSurface->Release();
	}
#endif
	return true;
}
/// CDXGdiFont::TextOutA Q
bool CDXGdiFont::TextOutW(int x, int y, LPCWSTR pString, size_t size)
{
	if( m_hFont == nullptr )
	{
		IRIS_WARNING( "HFONT is nullptr." );
		return false;
	}
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr || m_pTexture == nullptr || m_pSurface == nullptr ) return false;

	HDC hDC = m_hDC;
	LPDXSURFACE pSurface = nullptr;
	do
	{
		if( hDC == nullptr )
		{
			if( SUCCEEDED(m_pSurface->GetDC(&hDC)) )
			{
				m_hDC = hDC;
				pSurface = m_pSurface;
				break;
			}
		}

#if	defined(_IRIS_SUPPORT_DXMOBILE)
		if( FAILED(pDxDevice->GetDevice()->CreateImageSurface(m_Width, m_Height, D3DFMT_A8R8G8B8, &pSurface)) ) return false;
		if( FAILED(pSurface->GetDC(&hDC)) ) return false;
#else
		return false;
#endif
	} while(0);

	HBRUSH brush = (HBRUSH)CreateSolidBrush(0xff000000);

	// hԂ
	RECT rc;
	GetRect(&rc);
	FillRect(hDC, &rc, brush); 
	
	// F
	SetTextColor(hDC, 0xffffffff);
	int bkMode = SetBkMode(hDC, TRANSPARENT);	// wil
	
	// `
	DrawTextW(hDC, pString, size, &rc, 0);

	SetBkMode(hDC, bkMode);

	pSurface->ReleaseDC(hDC);
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( pSurface != m_pSurface )
	{
		pDxDevice->GetDevice()->CopyRects(pSurface, nullptr, 0, m_pSurface, nullptr);
		pSurface->Release();
	}
#endif
	return true;
}

/**********************************************************************//**
 *
 * tHg쐬
 * 
 ----------------------------------------------------------------------
 * @param [in]	height			= tHg
 * @param [in]	width			= 
 * @param [in]	escapement		= eLXg̊px	
 * @param [in]	orientation		= x[XCƂƂ̊px
 * @param [in]	weight			= tHg̏dij
 * @param [in]	bItalic			= C^bN
 * @param [in]	bUnderline		= A_[C
 * @param [in]	bStrikeOut		= ł
 * @param [in]	iCharSet		= Zbg
 * @param [in]	iOutPrecision	= o͐x
 * @param [in]	iClipPrecision	= NbsOx
 * @param [in]	iQuality		= o͕i
 * @param [in]	iPitchAndFamily	= sb`ƃt@~[
 * @param [in]	pszFaceName		= ̖
 * @return	
*//***********************************************************************/
bool CDXGdiFont::CreateFontA(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCSTR pszFaceName
						)
{
	LOGFONTA lf = {
		height,					// tHg
		width,					// 
		escapement,				// eLXg̊px	
		orientation,			// x[XCƂƂ̊px
		weight,					// tHg̏dij
		(BYTE)bItalic,			// C^bN
		(BYTE)bUnderline,		// A_[C
		(BYTE)bStrikeOut,		// ł
		(BYTE)iCharSet,			// Zbg
		(BYTE)iOutPrecision,	// o͐x
		(BYTE)iClipPrecision,	// NbsOx
		(BYTE)iQuality,			// o͕i
		(BYTE)iPitchAndFamily,	// sb`ƃt@~[
		""						// ̖
	};
	strcpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateFontIndirectA( &lf );
}
/// CDXGdiFont::CreateFontA Q
bool CDXGdiFont::CreateFontW(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName
						)
{
	LOGFONTW lf = {
		height,					// tHg
		width,					// 
		escapement,				// eLXg̊px	
		orientation,			// x[XCƂƂ̊px
		weight,					// tHg̏dij
		(BYTE)bItalic,			// C^bN
		(BYTE)bUnderline,		// A_[C
		(BYTE)bStrikeOut,		// ł
		(BYTE)iCharSet,			// Zbg
		(BYTE)iOutPrecision,	// o͐x
		(BYTE)iClipPrecision,	// NbsOx
		(BYTE)iQuality,			// o͕i
		(BYTE)iPitchAndFamily,	// sb`ƃt@~[
		L""						// ̖
	};
	wcscpy_s(lf.lfFaceName, sizeof(lf.lfFaceName)/sizeof(WCHAR), pszFaceName);
	return CreateFontIndirectW( &lf );
}

/**********************************************************************//**
 *
 * tHg쐬
 * 
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
bool CDXGdiFont::CreateFontIndirectA(const LOGFONTA* lplf)
{
	if( m_hFont != nullptr ) return false;
	m_hFont = ::CreateFontIndirectA(lplf);
	if( m_hFont == nullptr ) return false;

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXPRESENT_PARAMETERS pPresent = GetPresent();
	HWND hWnd = pPresent != nullptr ? pPresent->hDeviceWindow : nullptr;
	HDC hDC = GetDC(hWnd);
#else
	HWND hWnd = nullptr;
	HDC hDC = nullptr;
	HDC hSurfaceDC = nullptr;
	do
	{
		if( m_pSurface != nullptr )
		{
			HRESULT hr = m_pSurface->GetDC(&hSurfaceDC);
			if( SUCCEEDED(hr) ) 
			{
				hDC = hSurfaceDC;
				break;
			}
		}
		hDC = GetDC(nullptr);
	} while(0);
#endif
	HFONT oldFont = (HFONT)SelectObject(hDC, m_hFont);

	// tHg擾
	TEXTMETRIC tm;
	GetTextMetrics(hDC, &tm);
	m_FontWidth = tm.tmMaxCharWidth;
	m_FontHeight= tm.tmHeight + tm.tmExternalLeading*2;

	SelectObject(hDC, oldFont);
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( hSurfaceDC != nullptr )
	{
		m_pSurface->ReleaseDC(hDC);
	}
	else
#endif
	{
		ReleaseDC(hWnd, hDC);
	}
	return true;
}
/// CDXGdiFont::CreateFontIndirectA Q
bool CDXGdiFont::CreateFontIndirectW(const LOGFONTW* lplf)
{
	if( m_hFont != nullptr ) return false;
	m_hFont = ::CreateFontIndirectW(lplf);
	if( m_hFont == nullptr ) return false;

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXPRESENT_PARAMETERS pPresent = GetPresent();
	HWND hWnd = pPresent != nullptr ? pPresent->hDeviceWindow : nullptr;
	HDC hDC = GetDC(hWnd);
#else
	HWND hWnd = nullptr;
	HDC hDC = nullptr;
	HDC hSurfaceDC = nullptr;
	do
	{
		if( m_pSurface != nullptr )
		{
			HRESULT hr = m_pSurface->GetDC(&hSurfaceDC);
			if( SUCCEEDED(hr) ) 
			{
				hDC = hSurfaceDC;
				break;
			}
		}
		hDC = GetDC(nullptr);
	} while(0);
#endif
	HFONT oldFont = (HFONT)SelectObject(hDC, m_hFont);

	// tHg擾
	TEXTMETRIC tm;
	GetTextMetrics(hDC, &tm);
	m_FontWidth = tm.tmMaxCharWidth;
	m_FontHeight= tm.tmHeight + tm.tmExternalLeading*2;

	SelectObject(hDC, oldFont);
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( hSurfaceDC != nullptr )
	{
		m_pSurface->ReleaseDC(hDC);
	}
	else
#endif
	{
		ReleaseDC(hWnd, hDC);
	}
	return true;
}

/**********************************************************************//**
 *
 * tHg
 *
*//***********************************************************************/
void CDXGdiFont::DeleteFont(void)
{
	DeleteObject(m_hFont);
	m_hDC = nullptr;
	m_hFont = nullptr;
	m_FontWidth = -1;
	m_FontHeight = -1;
}

}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/DXDebugUnitTest.h"
#include "../DXObjectManager.h"
#include "../scene/DXCamera.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// test
IRIS_UNITTEST_P(CDXGdiFontUnitTest, iris::dx::dbg::CDXUnitTestBase<CDXGdiFontUnitTest>, DXGdiFontUnitTest)
{
#define WINDOW_STYLE	( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX )
#define WINDOW_STYLEEX	( WS_EX_OVERLAPPEDWINDOW )
	HWND hWnd = nullptr;
	TCHAR* pName = TEXT("sample");
	HINSTANCE hInstance = (HINSTANCE)GetModuleHandle(nullptr);

	RECT src = {0, 0, 640, 480};

	// EBhEg̒
	AdjustWindowRectEx(&src, WINDOW_STYLE, FALSE, WINDOW_STYLEEX);

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, pName, pName, WINDOW_STYLE
		, src.right, src.bottom, WindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	ShowWindow( hWnd, SW_HIDE );
	CDXDevice dev(hWnd);
	CDXObjectManager objMan(&dev.GetDXSwapChain());
	if( !dev.CreateDevice(src.right, src.bottom, false, false, false, false, false, false) )
	{
		goto exit;
	}
	dev.CreateSprite();
	objMan.CreateLayer<CDXDefaultLayer>(0);
	//CDXCamera* pCamera = devEx.CreateObject<CDXCamera>();
	//pCamera->SetPos(D3DXVECTOR3(0.0f, 0.0f, -10.0f));
	//pCamera->SetViewport();
	//pCamera->Activate();

	IDXFont* pFont = objMan.CreateLayerObject<CDXGdiFont>(0);

	CHAR buf[256] = "TEST";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "͂ĂB" << std::endl;
	std::cin >> buf;
#endif

	pFont->Create(src.right,src.bottom);
	pFont->CreateFont(50,0,FW_NORMAL,0,0,0
		, SHIFTJIS_CHARSET
		, OUT_TT_PRECIS
		, PROOF_QUALITY
		, FIXED_PITCH | FF_MODERN
		, TEXT("lr ") );
	pFont->Clear();
	pFont->SetFontColor(0xFF22FF22);
	pFont->TextOutA(0, 0, buf, strlen(buf) ); 
	pFont->EnableRenderState(IDXTexture::DXTRS_DRAWSPRITE);
	pFont->SetWorldPos( &D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

	CDXGdiFontUnitTest* pUT = CDXGdiFontUnitTest::GetCurrent();
	pUT->SetDevice(&dev);

	// EBhE`
	ShowWindow( hWnd, SW_SHOW );
	// EBhE̍XV
	UpdateWindow( hWnd );
	// őOʂ
	SetForegroundWindow(hWnd);

	wx::dbg::UnitTestMainLoop(hWnd);

exit:
	UnregisterClass(pName, hInstance);
}


//**********************************************************************
//
// eXgpEBhEvV[W
// 
//----------------------------------------------------------------------
// @param	hWnd	EBhEnh
// @param	uMsg	sꂽbZ[W
// @param	wParam	sꂽbZ[W@
// @param	lParam	sꂽbZ[WA
// @return	LRESULTl
//**********************************************************************
LRESULT CALLBACK WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	case WM_PAINT:
		{
			CDXGdiFontUnitTest* pUT = CDXGdiFontUnitTest::GetCurrent();
			pUT->Draw();
		}
		break;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
		break;
	}

	return 0L;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
