//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLayer.h
 * @brief		directX C[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXLayer_H_
#define INCG_IRIS_DXLayer_H_

//======================================================================
// include
#include "../texture/DXRenderTarget.h"
#include "fnd/container/FndList.h"
#include <vector>
#include <map>

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXDevice;
class IDXSwapChain;
class CDXLayerMgr;

//======================================================================
// class
//! C[NXC^[tFCX
class IDXLayer : public INonCopyable<IDXLayer>
{
	friend class CDXLayerMgr;
	friend class CDXDevice;
public:
	typedef fnd::CDrawCollector		Drawer;
	typedef fnd::CUpdateCollector	Updater;
	typedef enum
	{ 
		LAYERID_NONE = -1 
	} LAYERID;
	typedef enum RENDERSTATE
	{
		DXLYRS_DEFAULT		= 0x00000001,
		DXLYRS_TERM
	} RENDERSTATE;
private:
	CDXLayerMgr*		m_pManager;
protected:
	int					m_LayerID;		//!< C[ID
	u32					m_RenderState;	//!< _OXe[g
	Drawer				m_Drawer;		//!< `惊Xg
	Updater				m_Updater;		//!< XVXg
public:
	// RXgN^
	IDXLayer(void);
	// fXgN^
	virtual ~IDXLayer(void);
public:
	// XV
	virtual void	UpdateLayer(f32 time);
	// `
	virtual	void	DrawLayer(void);
	virtual	void	Begin(void) = 0;
	virtual	void	End(void) = 0;
public:
	/// C[ID̎擾
	int				GetLayerID(void)	{ return m_LayerID; }
	// ǉ
	void			PushBack(IDXGXObject* obj);
	// 폜
	bool			Erase(IDXGXObject* obj);

public:
	// Updaterɒǉ
	void			RegisterUpdater(IDXGXObject* obj);
	// Drawerɒǉ
	void			RegisterDrawer(IDXGXObject* obj);
	// Updater폜
	bool			EraseUpdater(IDXGXObject* obj);
	// Drawer폜
	bool			EraseDrawer(IDXGXObject* obj);

	// Drawer̃\[g
	void			SortDrawer(void);

protected:
	virtual bool	AttachDevice(IDXSwapChain*)	{ return true; }
	virtual void	DetachDevice(void)			{}
private:
	void	SetLayerID(int id, CDXLayerMgr* pMgr=nullptr)	{ m_LayerID = id; m_pManager = pMgr; }
};

//======================================================================
//! ftHgC[NX
class CDXDefaultLayer : public IDXLayer
{
public:
	// RXgN^
	CDXDefaultLayer(void);
	// fXgN^
	virtual ~CDXDefaultLayer(void);
public:
	/// 쐬
	virtual bool	Create(void) { return true; }
public:
	// `
	virtual	void	Begin(void);
	virtual	void	End(void);
};

//======================================================================
//! C[NXi_[^[QbgLj
class CDXLayer : public CDXRenderTarget, public CDXDefaultLayer
{
private:
	LPDXSURFACE	m_pPreSurface;	//!< ȑÕobNobt@
	LPDXSURFACE	m_pPreStencil;	//!< ȑÕXeVobt@

public:
	// RXgN^
	CDXLayer(void);
	// fXgN^
	virtual ~CDXLayer(void);
public:
	// 쐬
	virtual bool	Create(void);
public:
	// `Jn
	virtual void	Begin(void);
	virtual void	PreDraw(void)	{ Begin(); }
	// `I
	virtual void	End(void);
	virtual void	PostDraw(void)	{ End(); }

protected:
	// XgA
	virtual	void	Restore(void);
protected:
	virtual bool	AttachDevice(IDXSwapChain* pSwapChain=nullptr);
};

//======================================================================
//! C[ǗNXCxgNX
class IDXLayerEvent : public IIrisObject
{
public:
	/// RXgN^
	IDXLayerEvent(void);
	/// fXgN^
	//virtual ~IDXLayerEvent(void);
public:
	/// C[`O
	virtual void	OnDrawLayer(IDXLayer* layer)	= 0;
};

//======================================================================
//! C[ǗNX
class CDXLayerMgr : public INonCopyable<>
{
	friend class CDXDevice;		//!< foCXǗNX̃ANZX
	friend class IDXSwapChain;	//!< Xbv`F[̃ANZX
public:
	typedef std::map<int, IDXLayer*>	mapLayer;
	typedef std::pair<int, IDXLayer*>	pairLayer;
private:
	//! C[
	mapLayer					m_Layers;
	//! Cxg
	IDXLayerEvent*				m_pEvent;
public:
	// RXgN^
	CDXLayerMgr(void);
	// fXgN^
	virtual ~CDXLayerMgr(void);

	// XV
	void		Update(f32 time);
	// `
	void		Draw(void);

public:

	// C[̒ǉ
	bool		RegisterLayer(int LayerID, IDXLayer* layer, IDXSwapChain* pSwapChain);
	// C[̍폜
	bool		EraseLayer(int LayerID);
	bool		EraseLayer(IDXLayer* layer);
	void		EraseLayerAll(void);
	// C[̍폜ideletej
	bool		ReleaseLayer(int LayerID);
	void		ReleaseLayerAll(void);

	// C[̎擾
	IDXLayer*	GetLayer(int LayerID);
	// ̃C[݂邩ǂ
	bool		IsRegisteredLayer(IDXLayer* layer);

public:
	// C[ɃIuWFNgǉ
	bool		RegisterLayerObject(int LayerID, IDXGXObject* obj);
	// C[IuWFNg폜
	bool		EraseLayerObject(int LayerID, IDXGXObject* obj);

protected:
	// C[狭폜
	void		EraseLayerObjectForce(IDXGXObject* obj);

public:
	// event
	void			SetEvent(IDXLayerEvent* pEvent)	{ m_pEvent = pEvent; }
	IDXLayerEvent*	GetEvent(void)					{ return m_pEvent; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
