//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLight.h
 * @brief		directX Cgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXLight_H_
#define INCG_IRIS_DXLight_H_

//======================================================================
// include
#include "../DXObject.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class
//! CgݒNX
class CDXLight : virtual public IDXGXObject
{
	friend class CDXDevice;
protected:
	BOOL		m_bEnable;
	DXLIGHT		m_Light;
	DWORD		m_dwIdx;

public:
	// RXgN^
	CDXLight(void);
	explicit CDXLight(LPDXLIGHT pLight, DWORD idx=0);
	// fXgN^
	virtual ~CDXLight(void);
public:
	// 쐬
	virtual bool	Create(void) { return true; }
public:
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);
public:
	// Cgݒ
	virtual void	Activate(void);
protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:

	// index
	void			SetIndex(DWORD idx)		{ m_dwIdx = idx; }
	DWORD			GetIndex(void)			{ return m_dwIdx; }
	// Enable
	void			SetEnable(BOOL enable)	{ m_bEnable = enable; }
	void			Enable(void)			{ SetEnable(true); }
	void			Disable(void)			{ SetEnable(false); }
	BOOL			GetEnable(void)			{ return m_bEnable; }

	// D3DLIGHT_DIRECTIONAL
	void			SetDirectionalLight(intr::LPDXICOLOR diffuse, intr::LPDXICOLOR specular, intr::LPDXICOLOR ambient, D3DXVECTOR3* direction)	{
		SetType(D3DLIGHT_DIRECTIONAL); SetDiffuse(diffuse); SetSpecular(specular); SetAmbient(ambient); SetDirection(direction); 
	}
public:

	// Set
	void			SetLight(LPDXLIGHT pLight)	{ if( pLight != nullptr ) m_Light = *pLight; }
	//DXLIGHT&		GetLight(void)				{ return m_Light; }
	// Type
	void			SetType(DXLIGHTTYPE type)	{ m_Light.Type = type; }
	DXLIGHTTYPE		GetType(void)				{ return m_Light.Type; }
	// Diffuse
	void			SetDiffuse(intr::LPDXICOLOR color)		{ SetDiffuse(color->r, color->g, color->b, color->a); }
	void			SetDiffuse(f32 r, f32 g, f32 b, f32 a);
	D3DCOLORVALUE	GetDiffuse(void)						{ return m_Light.Diffuse; }
	// Specular
	void			SetSpecular(intr::LPDXICOLOR color)		{ SetSpecular(color->r, color->g, color->b, color->a); }
	void			SetSpecular(f32 r, f32 g, f32 b, f32 a);
	D3DCOLORVALUE	GetSpecular(void)						{ return m_Light.Specular; }
	// Ambient
	void			SetAmbient(intr::LPDXICOLOR color)		{ SetAmbient(color->r, color->g, color->b, color->a); }
	void			SetAmbient(f32 r, f32 g, f32 b, f32 a);
	D3DCOLORVALUE	GetAmbient(void)						{ return m_Light.Ambient; }
	// Positon
	void			SetPositon(D3DXVECTOR3* pos)			{ SetPositon(pos->x, pos->y, pos->z); }
	void			SetPositon(f32 x, f32 y, f32 z);
	DXVECTOR		GetPositon(void)						{ return m_Light.Position; }
	// Direction
	void			SetDirection(D3DXVECTOR3* dir)			{ SetDirection(dir->x, dir->y, dir->z); }
	void			SetDirection(f32 x, f32 y, f32 z);
	DXVECTOR		GetDirection(void)						{ return m_Light.Direction; }
	// Range
	void			SetRange(f32 range)						{ m_Light.Range = range; }
	f32				GetRange(void)							{ return m_Light.Range; }
	// Falloff
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	void			SetFalloff(f32 falloff)					{ m_Light.Falloff = falloff; }
	f32				GetFalloff(void)						{ return m_Light.Falloff; }
#endif
	// Attenuation
	void			SetAttenuation(f32 at0, f32 at1, f32 at2)	{ m_Light.Attenuation0 = at0; m_Light.Attenuation1 = at1; m_Light.Attenuation2 = at2; }
	void			SetAttenuation0(f32 at)					{ m_Light.Attenuation0 = at; }	// Constant
	void			SetAttenuation1(f32 at)					{ m_Light.Attenuation1 = at; }	// Linear
	void			SetAttenuation2(f32 at)					{ m_Light.Attenuation2 = at; }	// Quadratic
	f32				GetAttenuation0(void)					{ return m_Light.Attenuation0; }// Constant
	f32				GetAttenuation1(void)					{ return m_Light.Attenuation1; }// Linear
	f32				GetAttenuation2(void)					{ return m_Light.Attenuation2; }// Quadratic
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	// Theta
	void			SetTheta(f32 theta)						{ m_Light.Theta = theta; }
	f32				GetTheta(void)							{ return m_Light.Theta; }
	// Phi
	void			SetPhi(f32 phi)							{ m_Light.Phi = phi; }
	f32				GetPhi(void)							{ return m_Light.Phi; }
#endif
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
