//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMaterial.cpp
 * @brief		}eANXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMaterial_CPP_

//======================================================================
// include
#include "DXMaterial.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMaterial::CDXMaterial(const intr::DXICOLOR& diffuse
		, const intr::DXICOLOR& ambient
		, const intr::DXICOLOR& specular
		, const intr::DXICOLOR& emissive
		, f32 power
		)
{
	SetDiffuse	(diffuse);
	SetAmbient	(ambient);
	SetSpecular	(specular);
	SetEmissive	(emissive);
	SetPower	(power);
}

/**********************************************************************//**
 *
 * Diffuse ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXMaterial::SetDiffuse(f32 r, f32 g, f32 b, f32 a)
{
	Diffuse.r = r;
	Diffuse.g = g;
	Diffuse.b = b;
	Diffuse.a = a; 
}

/**********************************************************************//**
 *
 * Specular ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXMaterial::SetSpecular(f32 r, f32 g, f32 b, f32 a)
{ 
	Specular.r = r;
	Specular.g = g; 
	Specular.b = b;
	Specular.a = a;
}

/**********************************************************************//**
 *
 * Ambient ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXMaterial::SetAmbient(f32 r, f32 g, f32 b, f32 a)
{ 
	Ambient.r = r;
	Ambient.g = g; 
	Ambient.b = b;
	Ambient.a = a;
}

/**********************************************************************//**
 *
 * Emissive ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXMaterial::SetEmissive(f32 r, f32 g, f32 b, f32 a)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	Emissive.r = r;
	Emissive.g = g; 
	Emissive.b = b;
	Emissive.a = a;
#else
	IRIS_UNUSED_VARIABLE(r);
	IRIS_UNUSED_VARIABLE(g);
	IRIS_UNUSED_VARIABLE(b);
	IRIS_UNUSED_VARIABLE(a);
#endif
}

}	// end of namespace dx
}	// end of namespace iris
