//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMesh.h
 * @brief		directX bVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMesh_H_
#define INCG_IRIS_DXMesh_H_

//======================================================================
// include
#include "../DXObject.h"
#include "../../DXFlags.h"

namespace iris {
namespace dx
{

//======================================================================
// typedef
// R[obN֐
/// eNX`̐R[obN
typedef HRESULT (*PFN_DXMeshCreateTexture)(  LPDXDEVICE pDevice
										 , LPCSTR filename 
										 , LPDXTEXTURE* pTexture
										);
/// eNX`̍폜R[obN
typedef HRESULT	(*PFN_DXMeshDeleteTexture)(LPDXTEXTURE* pTexture);

//======================================================================
// function
extern HRESULT DXMeshDefaultCreateTexture(  LPDXDEVICE pDevice
										  , LPCSTR filename
										  , LPDXTEXTURE* pTexture
										  );
extern HRESULT DXMeshDefaultDeleteTexture(LPDXTEXTURE* pTexture);

//======================================================================
// class
//! bVNXC^[tFCX
class IDXMesh : virtual public IDXMtxObject, public dx::flag::CRenderState
{
public:
	/// _OXe[g
	typedef enum RENDERSTATE
	{
		DXMRS_ENABLELIGHT	= 0x00000001,	//!< CgL
		DXMRS_CULLFACE		= 0x00000002,	//!< tFCXJO

		DXMRS_DEFAULT		= 0x00000001,	//!< ftHgݒ
		DXMRS_TERM
	} RENDERSTATE;	//!< _OXe[g
public:
	// RXgN^
	IDXMesh(void);
	// fXgN^
	virtual ~IDXMesh(void);
public:
    // xt@C̓ǂݍ
	virtual bool	Load(LPCTSTR pFileame) = 0;
	virtual bool	LoadDirectory(LPCTSTR pCurrentDirectory, LPCTSTR pFileame);

	// [hς݂ǂ
	virtual bool	IsValid(void) = 0;

public:
	// bV\̂̎擾
	virtual LPDXMESH			GetMesh(void)				= 0;
	// }eA̐擾
	virtual DWORD				GetMaterialNum(void)		= 0;
	// }eA̎擾
	virtual	LPDXMATERIAL		GetMaterial(DWORD dwIndex)	= 0;
	/// eNX`̎擾
	virtual	LPDXTEXTURE			GetTexture(DWORD dwIndex)	= 0;

public:
	// 쐬
	virtual bool	Create(void)	{ return true; }
public:
	// XV
	virtual void	Update(f32 /*time*/)	{}
	// `
	virtual void	PreDraw(void);
	// 
	virtual void	Release(void);

	// _OXe[gݒ
	virtual void	SetupRenderState(void);

protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
