//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMeshFrame.h
 * @brief		directX bVReibVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMeshFrame_H_
#define INCG_IRIS_DXMeshFrame_H_

//======================================================================
// include
#include "DXMesh.h"
#include "frame/DXTexFrame.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class
//! bVReibVNX
class CDXMeshFrame : public IDXMesh
{
protected:
    LPD3DXMATRIXSTACK			m_pMatrixStack;	//!< X^bN}gbNX
	LPD3DXFRAME					m_pFrame;		//!< bVt[
	LPD3DXANIMATIONCONTROLLER	m_pAnim;		//!< Aj[VRg[
	CDXTexFrameAllocHierarchy	m_Hierarchy;	//!< AP[^
public:
	// RXgN^
	CDXMeshFrame(void);
	// fXgN^
	virtual ~CDXMeshFrame(void);
public:
	// `
	virtual	void	Draw(void);
	virtual	void	DrawHierarchies(LPD3DXFRAME pFrame);
	// 
	virtual	void	Release(void);

public:
    // xt@C̓ǂݍ
	virtual bool	Load(LPCTSTR pFileame);

	// [hς݂ǂ
	virtual bool	IsValid(void);

public:
	// ݂̃}gbNXɐݒ
	virtual void	LoadMatrix(LPD3DXMATRIX pMatrix);
	virtual void	SetWorldMatrix(LPD3DXMATRIX pMatrix)		{ LoadMatrix(pMatrix); IDXMesh::SetWorldMatrix(pMatrix); }
	/// }gbNXݒ
	virtual void	OnCalcLocalMatrix(LPD3DXMATRIX pMatrix)			{}
	/// }eA␳
	virtual void	OnCalcLocalMaterial(LPDXMATERIAL pMaterial)	{}

public:
	// bV\̂̎擾
	virtual LPDXMESH			GetMesh(void);
	// }eA̐擾
	virtual DWORD				GetMaterialNum(void);
	// }eA̎擾
	virtual	LPDXMATERIAL		GetMaterial(DWORD dwIndex);
	// eNX`̎擾
	virtual	LPDXTEXTURE			GetTexture(DWORD dwIndex);

public:
	LPD3DXFRAME					GetFrame(void)				{ return m_pFrame; }
	LPD3DXANIMATIONCONTROLLER	GetAnimCtrl(void)			{ return m_pAnim; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
