//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXTexFrame.h
 * @brief		directX eNX`tbVReit@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXTexFrame_H_
#define INCG_IRIS_DXTexFrame_H_

//======================================================================
// include
#include "DXFrame.h"

namespace iris {
namespace dx
{

//======================================================================
// struct
// eNX`tRei
typedef struct tagD3DXMESHCONTAINEREX : public _D3DXMESHCONTAINER
{
	LPDXTEXTURE*	pTextures;	//!< eNX`|C^z
} D3DXMESHCONTAINEREX			//!< eNX`tRei
, *LPD3DXMESHCONTAINEREX;

//======================================================================
// class
//! (D3DXMESHCONTAINEREX)Alloctor
class CDXTexFrameAllocHierarchy : public CDXFrameAllocHierarchy
{
protected:
	PFN_DXMeshCreateTexture	m_pfnCreateTexture;	//!< eNX`R[obN
	PFN_DXMeshDeleteTexture	m_pfnDeleteTexture;	//!< eNX`폜R[obN

public:
	// RXgN^
	CDXTexFrameAllocHierarchy(void);
	// fXgN^
	~CDXTexFrameAllocHierarchy(void);

public:

	// eNX`R[obNݒ
	void	SetCreateTextureFunction(PFN_DXMeshCreateTexture func)	{ m_pfnCreateTexture = func; }
	// eNX`폜R[obNݒ
	void	SetDeleteTextureFunction(PFN_DXMeshDeleteTexture func)	{ m_pfnDeleteTexture = func; }

public:
    // bV Rei IuWFNg̊蓖ĉv
    virtual HRESULT __stdcall DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerToFree);

protected:
	// Rei\̂̊m
	virtual D3DXMESHCONTAINER*	AllocateContainer(void);
	// }eA̍쐬
	virtual	bool				CreateMaterials(D3DXMESHCONTAINER* pContainer, const D3DXMATERIAL *pMaterials, DWORD NumMaterials);
	// eNX`̍쐬
	virtual	bool				CreateTexture(D3DXMESHCONTAINER* pContainer, LPCSTR lpFileName, DWORD dwIndex);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
