//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessageData.h
 * @brief		directX bZ[Wf[^NXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMessageData_H_
#define INCG_IRIS_DXMessageData_H_

//======================================================================
// include
#include <map>
#include <vector>
#include "../../DXFlags.h"
#include "../font/DXFont.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXMessageData;
class CDXMessage;

//======================================================================
// class
//======================================================================
//! bZ[Wf[^NX
class CDXMessageData : public dx::flag::CRenderState
{
public:
	typedef std::vector<UINT>	vecCode;

protected:
	vecCode		m_Code;		//!< bZ[Wf[^
	int			m_Length;	//!< \
	D3DXVECTOR3	m_Min;		//!< `̈iŏj
	D3DXVECTOR3 m_Max;		//!< `̈iőj

public:
	// RXgN^
	CDXMessageData(void);
	// fXgN^
	~CDXMessageData(void);
public:
	// XV
	virtual void		Update(f32 time);
	// `ʒǔvZ(ŃCfgƂ)
	virtual void		CalcPosition(int loop, int idx, int width, int height, D3DXVECTOR3& pos);
	// `Xe[gݒ(ŃJ[ύXƂ)
	virtual void		CalcState(UINT code, IDXFont* font)	{}
public:
	// R[hݒ
	virtual void		SetCodeA(LPCSTR  pString, size_t size);
	virtual void		SetCodeW(LPCWSTR pString, size_t size);
	virtual void		SetCodeX(const UINT* codes, size_t size);
#ifdef UNICODE
	virtual void		SetCode(LPCWSTR pString, size_t size)	{ SetCodeW(pString,size); }
#else
	virtual void		SetCode(LPCSTR  pString, size_t size)	{ SetCodeA(pString,size); } 
#endif
	// R[h擾
	virtual vecCode&	GetCode(void)			{ return m_Code; }
	// \擾
	virtual int			GetShowLength(void)		{ int size = (int)m_Code.size(); return (m_Length < 0 || m_Length > size) ? size : m_Length; }
	// `掞vZ
	virtual int			GetCalcLoopCount(void)	{ return 1; }

public:
	// set, get
	int		GetLength(void)		{ return m_Length; }
	void	SetLength(int len)	{ m_Length = len; }

	D3DXVECTOR3*	GetMin(void)					{ return &m_Min; }
	void			SetMin(const D3DXVECTOR3* min)	{ m_Min = *min; }
	D3DXVECTOR3*	GetMax(void)					{ return &m_Max; }
	void			SetMax(const D3DXVECTOR3* max)	{ m_Max = *max; }

};

//======================================================================
//! bZ[Wf[^ǗNX
class CDXMessage : public IIrisObject
{
public:
	// bZ[Wf[^
	typedef CDXMessageData					*LPMessageData;
	typedef std::map<UINT, LPMessageData>	CDataMap;
	typedef std::pair<UINT, LPMessageData>	CDataPair;
	typedef CDataMap::iterator				iterator;

protected:
	UINT		m_ResID;	//!< tHg\[XID
	CDataMap	m_Data;		//!< bZ[Wf[^

public:
	// RXgN^
	CDXMessage(void);
	explicit CDXMessage(UINT uResID);
	// fXgN^
	~CDXMessage(void);

public:
	// XV
	virtual void	Update(f32 time);
	// 
	virtual void	Release(void);

	/// f[^ǉ
	template<class _TC>
	_TC*				CreateMessageData(UINT uID)
	{
		if( GetMessageData(uID) != nullptr ) return nullptr;
		_TC* p = new _TC;
		m_Data.insert( CDataPair(uID, p) );
		return p;
	}
	/// f[^ǉ
	CDXMessageData*	CreateMessageData(UINT uID)
	{
		return CreateMessageData<CDXMessageData>(uID);
	}
	// f[^폜
	bool			DeleteMessageData(UINT uID);
	// f[^擾
	LPMessageData	GetMessageData(UINT uID);

public:
	// R[hƂ̃tHg\[XID̎擾
	virtual UINT		GetCodeResID(UINT /*code*/)	{ return m_ResID; }
			CDataMap&	GetMessageData(void)		{ return m_Data; }
public:
	// set,get
	UINT	GetResID(void)		{ return m_ResID; }
	void	SetResID(UINT uID)	{ m_ResID = uID; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
