//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXCamera.cpp
 * @brief		directX JNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXCamera_CPP_

//======================================================================
// include
#include "DXCamera.h"
#include "../DXDevice.h"
#include "../../DXCoordinates.h"

#include "../../../win/debug/WXDebug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXCamera::CDXCamera(void)
: m_Pos(0.0f,0.0f,-50.0f)
, m_LookAt(0.0f,0.0f,0.0f)
, m_Up(0.0f,1.0f,0.0f)
, m_fFovy(1.0f)
, m_fAspect(1.333333f)
, m_fNear(0.01f)
, m_fFar(1024.0f)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pos		= ʒu
 * @param [in]	lookat	= _
 * @param [in]	_near	= ߎ_
 * @param [in]	_far	= _
 * @param [in]	up		= xNg
 * @param [in]	fovy	= p
 * @param [in]	aspect	= AXyNg
*//***********************************************************************/
CDXCamera::CDXCamera(  D3DXVECTOR3* pos
					 , f32 distance
					 , D3DXVECTOR3* lookat
					 , f32 _near, f32 _far
					 , D3DXVECTOR3 *up
					 , f32 fovy, f32 aspect)
: m_Pos(*pos)
, m_LookAt(*lookat)
, m_Up(*up)
, m_fFovy(fovy)
, m_fAspect(aspect)
, m_fNear(_near)
, m_fFar(_far)
, m_fDistance(distance)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXCamera::~CDXCamera(void)
{
}

/**********************************************************************//**
 *
 * r[gXtH[
 *
*//***********************************************************************/
void CDXCamera::ViewTransform(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	D3DXMatrixLookAt(&m_matView , &m_Pos, &m_LookAt, &m_Up);
	pDevice.SetTransform(D3DTS_VIEW , &m_matView);
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXSPRITE pSprite = GetSprite();
	if( pSprite == nullptr ) return;
	D3DXMATRIX matWorld;
	D3DXMatrixIdentity(&matWorld);
#ifdef _IRIS_DX_RIGHTHAND
	pSprite->SetWorldViewRH(&matWorld, &m_matView);
#else
	pSprite->SetWorldViewLH(&matWorld, &m_matView);
#endif
#endif
}

/**********************************************************************//**
 *
 * vWFNVgXtH[
 *
*//***********************************************************************/
void CDXCamera::ProjectionTransform(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	D3DXMatrixPerspectiveFov(&m_matProj, m_fFovy, m_fAspect, m_fNear, m_fFar);
	pDevice.SetTransform(D3DTS_PROJECTION, &m_matProj);
}

/**********************************************************************//**
 *
 * r[|[g
 *
*//***********************************************************************/
void CDXCamera::SetViewport(void)
{
	CDXDevice*		pDxDevice	= GetDXDevice();
	IDXSwapChain*	pSwapChain	= GetDXSwapChain();
	if( pDxDevice == nullptr ) return;
	// r[|[g̍XV
	LPCDXDEVICE pDevice = pDxDevice->GetDevice();
	if( pDevice == nullptr ) return;
	LPCDXPRESENT_PARAMETERS present = pSwapChain->GetPresent();
	DXVIEWPORT view;
	pDevice->GetViewport(&view);
	view.Width = present->BackBufferWidth;
	view.Height= present->BackBufferHeight;
	pDevice->SetViewport(&view);
	m_fAspect = (f32)view.Width/(f32)view.Height;
}

/**********************************************************************//**
 *
 * r[|[g
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
*//***********************************************************************/
void CDXCamera::SetViewport(DWORD width, DWORD height)
{
	// r[|[g̍XV
	LPCDXDEVICE pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	DXVIEWPORT view;
	pDevice->GetViewport(&view);
	view.Width = width;
	view.Height= height;
	pDevice->SetViewport(&view);
	m_fAspect = (f32)view.Width/(f32)view.Height;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXCamera::Create(void)
{
	Activate();
	return true;
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXCamera::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
	Activate();
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXCamera::Draw(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXCamera::Release(void)
{
}

/**********************************************************************//**
 *
 * Zbg
 * 
*//***********************************************************************/
void CDXCamera::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 * 
*//***********************************************************************/
void CDXCamera::Restore(void)
{
	Create();
}

/**********************************************************************//**
 *
 * ݒ̍XV
 * 
*//***********************************************************************/
void CDXCamera::Activate(void)
{
	SetViewport();
	ViewTransform();
	ProjectionTransform();
}

/**********************************************************************//**
 *
 * XN[W[hWɕϊ
 * 
 ----------------------------------------------------------------------
 * @param [in]	pvecOut		= o̓xNg
 * @param [in]	pvecScreen	= XN[W
 * @return	pvecOut
*//***********************************************************************/
D3DXVECTOR3* CDXCamera::ScreenToWorld(D3DXVECTOR3* pvecOut, const D3DXVECTOR3* pvecScreen)
{
	LPCDXDEVICE pDevice = GetDevice();
	if( pDevice == nullptr ) return nullptr;
	DXVIEWPORT viewport;
	pDevice->GetViewport(&viewport);
	D3DXMATRIX matWorld;
	D3DXMatrixIdentity(&matWorld);
	return D3DXVec3Unproject(pvecOut, pvecScreen, &viewport, &m_matProj, &m_matView, &matWorld);
}

/**********************************************************************//**
 *
 * [hWXN[Wɕϊ
 * 
 ----------------------------------------------------------------------
 * @param [in]	pvecOut		= o̓xNg
 * @param [in]	pvecScreen	= [hW
 * @return	pvecOut
*//***********************************************************************/
D3DXVECTOR3* CDXCamera::WorldToScreen(D3DXVECTOR3* pvecOut, const D3DXVECTOR3* pvecWorld)
{
	LPCDXDEVICE pDevice = GetDevice();
	if( pDevice == nullptr ) return nullptr;
	DXVIEWPORT viewport;
	pDevice->GetViewport(&viewport);
	D3DXMATRIX matWorld;
	D3DXMatrixIdentity(&matWorld);
	return D3DXVec3Project(pvecOut, pvecWorld, &viewport, &m_matProj, &m_matView, &matWorld);
}

}	// end of namespace dx
}	// end of namespace iris
