//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXTexture.h
 * @brief		directX eNX`NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXTexture_H_
#define INCG_IRIS_DXTexture_H_

//======================================================================
// include
#include "../DXObject.h"
#include "../../DXFlags.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! eNX`NXC^[tFCX
class IDXTexture : virtual public IDXMtxObject, public dx::flag::CRenderState
{
public:
	/// _OXe[g
	typedef enum RENDERSTATE
	{
		DXTRS_ENABLELIGHT	= 0x00000001,	//!< CgL	

		DXTRS_DRAWSPRITE	= 0x80000000,	//!< XvCg`	
		DXTRS_DEFAULT		= 0x00000000,	//!< ftHgݒ
		DXTRS_TERM
	} RENDERSTATE;	//!< _OXe[g
protected:
	LPDXTEXTURE	m_pTexture;			//!< eNX`
	LPDXSURFACE	m_pSurface;			//!< T[tFCX

	D3DCOLOR			m_Color;			//!< _J[
	UINT				m_Width;			//!< 
	UINT				m_Height;			//!< 
	D3DXVECTOR2			m_TexSize;			//!< `TCY
	D3DXVECTOR2			m_UV0, m_UV1;		//!< eNX`W(0.0f`width,0.0f`height)

public:
	// RXgN^
	IDXTexture(void);
	// tex_sizeɕĂƃ[hɎIɃt@C̃eNX`TCYɐݒ肳܂B
	IDXTexture(intr::DXICOLOR& color, D3DXVECTOR2* tex_size);
	// fXgN^
	virtual ~IDXTexture(void);
public:
	// 쐬
	virtual bool	Create(void) { return true; }
public:
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	virtual void	Draw3D(void);
	virtual void	Draw2D(void);
	// 
	virtual	void	Release(void);
public:
	// eNX`_OpCvCɓo^
	virtual HRESULT	SetTexture(DWORD stage);
	virtual HRESULT	ResetTexture(DWORD stage);

	virtual bool	CreateTexture(UINT width, UINT height, UINT MipLevel, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool);

public:

	// eNX`TCYobNobt@TCYɂ킹
	virtual	bool	FitBackBufferSize(void);

public:
	// set, get
	// color
	virtual	void		SetColor(const intr::DXICOLOR& color)	{ m_Color = color; }
	virtual	D3DCOLOR	GetColor(void)							{ return m_Color; }

	// texture size
	virtual	void		SetTextureSize(const D3DXVECTOR2* texsize)	{ m_TexSize = *texsize; }
	virtual	D3DXVECTOR2	GetTextureSize(void)						{ return m_TexSize; }

	// width,height
	virtual UINT		GetWidth(void)		{ return m_Width; }
	virtual UINT		GetHeight(void)		{ return m_Height; }

	void				GetRect(LPRECT lprc);

	// uv
	virtual	void		SetUV(f32 u0, f32 v0, f32 u1, f32 v1)	{ m_UV0.x = u0; m_UV0.y = v0; m_UV1.x = u1; m_UV1.y = v1; }

public:
	// wrap
	HRESULT	LockRect(UINT Level, DXLOCKED_RECT* pLockedRect, CONST RECT* pRect, DWORD Flags)
									{ return (m_pTexture == nullptr) ? S_FALSE : m_pTexture->LockRect(Level,pLockedRect,pRect,Flags); }
	HRESULT	UnlockRect(UINT Level)	{ return (m_pTexture == nullptr) ? S_FALSE : m_pTexture->UnlockRect(Level); }
};

//======================================================================
//! eNX`NX
class CDXTexture : public IDXTexture
{
public:
	// RXgN^
	CDXTexture(void);
	// fXgN^
	~CDXTexture(void);
public:
	// 쐬
	virtual	bool	Load(LPCTSTR path, intr::DXICOLOR remColor=0xFF000000, UINT width=0, UINT height=0, UINT mipmaplevel=1, DWORD usage=0
							, DWORD filter = D3DX_FILTER_NONE, DWORD mipFilter=D3DX_DEFAULT
							, DXIMAGE_INFO* srcInfo=nullptr, PALETTEENTRY* pltEntry=nullptr);
protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
