//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIColor.h
 * @brief		J[` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXIColor_H_
#define INCG_IRIS_DXIColor_H_

//======================================================================
// include
#include "dxi_inchead.h"
#include "fnd/types/FndColor.h"

namespace iris {
namespace dx {
namespace intr
{

//======================================================================
// struct
/**
 * @brief	J[\
*/
typedef struct tagDXICOLOR : public IrisTRGBA<f32>
{
	typedef IrisTRGBA<f32>	_Mybase;
	typedef f32				_Type;
public:
	tagDXICOLOR(void) {}
	tagDXICOLOR(_Type r, _Type g, _Type b, _Type a) : _Mybase(r, g, b, a) {}
	tagDXICOLOR(_Type *v) : _Mybase(v) {}
	template<typename _TN>
	tagDXICOLOR(_TN col) { fnd::CARGB8888 argb(col); argb.cast(*this); }
#if		defined(DX_SDK_VERSION)
	tagDXICOLOR(const D3DCOLORVALUE& cv)	{ r = cv.r; g = cv.g; b = cv.b; a = cv.a; }
	tagDXICOLOR(D3DCOLORVALUE* cv)			{ r = cv->r; g = cv->g; b = cv->b; a = cv->a; }
	tagDXICOLOR(const D3DCOLORVALUE* cv)	{ r = cv->r; g = cv->g; b = cv->b; a = cv->a; }
	tagDXICOLOR(const D3DXCOLOR& cv)		{ r = cv.r; g = cv.g; b = cv.b; a = cv.a; }
	tagDXICOLOR(D3DXCOLOR* cv)				{ r = cv->r; g = cv->g; b = cv->b; a = cv->a; }
	tagDXICOLOR(const D3DXCOLOR* cv)		{ r = cv->r; g = cv->g; b = cv->b; a = cv->a; }
#endif

public:

#if		defined(DX_SDK_VERSION)
#  if	(_IRIS_DXSDK_TARGET_VER > 9)
#  else
	operator D3DCOLORVALUE*			(void)			{ return reinterpret_cast<D3DCOLORVALUE*>(this); }
	operator const D3DCOLORVALUE*	(void)	const	{ return reinterpret_cast<const D3DCOLORVALUE*>(this); }
	operator D3DCOLORVALUE&			(void)			{ return *reinterpret_cast<D3DCOLORVALUE*>(this); }
	operator const D3DCOLORVALUE&	(void)	const	{ return *reinterpret_cast<const D3DCOLORVALUE*>(this); }
#  endif
	operator D3DXCOLOR*				(void)			{ return reinterpret_cast<D3DXCOLOR*>(this); }
	operator const D3DXCOLOR*		(void)	const	{ return reinterpret_cast<const D3DXCOLOR*>(this); }
	operator D3DXCOLOR&				(void)			{ return *reinterpret_cast<D3DXCOLOR*>(this); }
	operator const D3DXCOLOR&		(void)	const	{ return *reinterpret_cast<const D3DXCOLOR*>(this); }
#endif

public:
	operator IrisFColor*			(void)			{ return reinterpret_cast<IrisFColor*>(this); }
	operator const IrisFColor*		(void)	const	{ return reinterpret_cast<const IrisFColor*>(this); }
	operator IrisFColor&			(void)			{ return *reinterpret_cast<IrisFColor*>(this); }
	operator const IrisFColor&		(void)	const	{ return *reinterpret_cast<const IrisFColor*>(this); }

	operator DWORD					(void)	const	{ return fnd::CARGB8888(*reinterpret_cast<const IrisFColor*>(this)); }

} DXICOLOR, *LPDXICOLOR;


}	// end of namespace intr
}	// end of namespace dx
}	// end of namespace iris

#endif
