//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIDevice.cpp
 * @brief		DirectX foCXbsO t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXIDevice_CPP_

//======================================================================
// include
#include "DXIDevice.h"

namespace iris {
namespace dx {
namespace intr
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXIDevice::CDXIDevice(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	object	= foCX|C^
*//***********************************************************************/
CDXIDevice::CDXIDevice(const LPDXDEVICE object)
: _Mybase(object)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXIDevice::~CDXIDevice(void)
{
}

/**********************************************************************//**
 *
 * V[̊Jn
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::BeginScene(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_OK;
#else
	if( m_object == nullptr ) return E_POINTER;
	return m_object->BeginScene(); 
#endif
#else
	if( m_object == nullptr ) return E_POINTER;
	return m_object->BeginScene();
#endif
}

/**********************************************************************//**
 *
 * V[̏I
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::EndScene(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_OK;
#else
	if( m_object == nullptr ) return E_POINTER;
	return m_object->EndScene(); 
#endif
#else
	if( m_object == nullptr ) return E_POINTER;
	return m_object->EndScene();
#endif
}

/**********************************************************************//**
 *
 * NA
 *
 ----------------------------------------------------------------------
 * @param [in]	Count	= pRects ̔zɂ`̐
 * @param [in]	pRects	= NA`
 * @param [in]	Flags	= NAT[tFCXtO
 * @param [in]	Color	= _O ^[Qbg T[tFCXNA 32 rbg ARGB Fl
 * @param [in]	Z		= [xobt@ɕۑV z l
 * @param [in]	Stencil	= eXeV obt@̃Ggɕۑ鐮l
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::Clear(DWORD Count, const intr::LPDXIRECT pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->Clear(Count, *pRects, Flags, Color, Z, Stencil); 
#endif
#else
	return m_object->Clear(Count, *pRects, Flags, Color, Z, Stencil); 
#endif
}

/**********************************************************************//**
 *
 * [x/XeVT[tFCX̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	Width				= 
 * @param [in]	Height				= 
 * @param [in]	Format				= tH[}bg
 * @param [in]	MultiSample			= 
 * @param [in]	MultisampleQuality	= 
 * @param [in]	Discard				= 
 * @param [out]	ppSurface			= o
 * @param [in]	pSharedHandle		= 
 * @return	
*//***********************************************************************/
HRESULT CDXIDevice::CreateDepthStencilSurface(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample
	, DWORD MultisampleQuality, BOOL Discard, LPDXSURFACE *ppSurface, HANDLE *pSharedHandle)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->CreateDepthStencilSurface(Width, Height, Format, MultiSample, MultisampleQuality, Discard, ppSurface, pSharedHandle);
#else
	IRIS_UNUSED_VARIABLE(MultisampleQuality);
	IRIS_UNUSED_VARIABLE(Discard);
	IRIS_UNUSED_VARIABLE(pSharedHandle);
	return m_object->CreateDepthStencilSurface(Width, Height, Format, MultiSample, ppSurface);
#endif
}

/**********************************************************************//**
 *
 * eNX`̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	Width				= 
 * @param [in]	Height				= 
 * @param [in]	Levels				= mip x
 * @param [in]	Usage				= 
 * @param [in]	Format				= tH[}bg
 * @param [in]	Pool				= 
 * @param [out]	ppTexture			= o
 * @param [in]	pSharedHandle		= 
 * @return	
*//***********************************************************************/
HRESULT CDXIDevice::CreateTexture(UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool
		, LPDXTEXTURE* ppTexture, HANDLE* pSharedHandle)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->CreateTexture(Width, Height, Levels, Usage, Format, Pool, ppTexture, pSharedHandle);
#else
	IRIS_UNUSED_VARIABLE(pSharedHandle);
	return m_object->CreateTexture(Width, Height, Levels, Usage, Format, Pool, ppTexture);
#endif
}

/**********************************************************************//**
 *
 * eNX`̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	Stage		= ݒ肷Xe[W
 * @param [in]	pTexture	= eNX`
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetTexture(DWORD Stage, IDXBASETEXTURE* pTexture)
{
	if( m_object == nullptr ) return D3DERR_INVALIDCALL;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return D3DERR_INVALIDCALL;
#else
	return m_object->SetTexture(Stage, pTexture); 
#endif
#else
	return m_object->SetTexture(Stage, pTexture);
#endif
}

/**********************************************************************//**
 *
 * eNX`̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Stage		= ݒ肷Xe[W
 * @param [out]	ppTexture	= eNX`
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetTexture(DWORD Stage, IDXBASETEXTURE** ppTexture)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->GetTexture(Stage, ppTexture); 
#endif
#else
	return m_object->GetTexture(Stage, ppTexture);
#endif
}

/**********************************************************************//**
 *
 * SetTransform
 *
 ----------------------------------------------------------------------
 * @param [in]	State	= ݒ肷
 * @param [in]	pMatrix	= ݒl
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetTransform(D3DTRANSFORMSTATETYPE State, const D3DMATRIX* pMatrix)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->SetTransform(State, pMatrix); 
#endif
#else
	return m_object->SetTransform(State, pMatrix, D3DMFMT_D3DMVALUE_FIXED);
#endif
}

/**********************************************************************//**
 *
 * GetTransform
 *
 ----------------------------------------------------------------------
 * @param [in]	State	= ݒ肷
 * @param [out]	pMatrix	= o
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetTransform(D3DTRANSFORMSTATETYPE State, D3DMATRIX* pMatrix)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->GetTransform(State, pMatrix); 
#endif
#else
	D3DMFORMAT format;
	return m_object->GetTransform(State, pMatrix, &format);
#endif
}

/**********************************************************************//**
 *
 * _OXe[g̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	State	= ݒ肷
 * @param [in]	Value	= ݒl
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetRenderState(D3DRENDERSTATETYPE State, DWORD   Value)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->SetRenderState(State, Value); 
#endif
#else
	return m_object->SetRenderState(State, Value);
#endif
}

/**********************************************************************//**
 *
 * _OXe[g̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	State	= ݒ肷
 * @param [out]	pValue	= o
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetRenderState(D3DRENDERSTATETYPE State, DWORD* pValue)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->GetRenderState(State, pValue); 
#endif
#else
	return m_object->GetRenderState(State, pValue);
#endif
}

/**********************************************************************//**
 *
 * _O^[Qbg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	RenderTargetIndex	= CfbNX
 * @param [in]	pRenderTarget		= ^[QbgT[tFCX
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE pRenderTarget)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->SetRenderTarget(RenderTargetIndex, pRenderTarget); 
#endif
#else
	return m_object->SetRenderTarget(pRenderTarget, nullptr);
#endif
}

/**********************************************************************//**
 *
 * _O^[Qbg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	RenderTargetIndex	= CfbNX
 * @param [out]	ppRenderTarget		= ^[QbgT[tFCX
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE* ppRenderTarget)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if (_IRIS_DXSDK_TARGET_VER > 9)
	return S_FALSE;
#else
	return m_object->GetRenderTarget(RenderTargetIndex, ppRenderTarget); 
#endif
#else
	return m_object->GetRenderTarget(ppRenderTarget); 
#endif
}

/**********************************************************************//**
 *
 * fvXXeVobt@̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSurface	= fvXXeVobt@
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetDepthStencilSurface(LPDXSURFACE lpSurface)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->SetDepthStencilSurface(lpSurface);
#else
	LPDXSURFACE pRenderTarget;
	m_object->GetRenderTarget(&pRenderTarget);
	return m_object->SetRenderTarget(pRenderTarget, lpSurface);
#endif
}

/**********************************************************************//**
 *
 * fvXXeVobt@̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSurface	= fvXXeVobt@
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetDepthStencilSurface(LPDXSURFACE* lppSurface)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->GetDepthStencilSurface(lppSurface);
#else
	return m_object->GetDepthStencilSurface(lppSurface);
#endif
}

/**********************************************************************//**
 *
 * TvOXe[g̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	Sampler	= Tv[
 * @param [in]	Type	= ^Cv
 * @param [in]	Value	= l
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->SetSamplerState(Sampler, Type, Value);
#else
	IRIS_UNUSED_VARIABLE(Sampler);
	IRIS_UNUSED_VARIABLE(Type);
	IRIS_UNUSED_VARIABLE(Value);
	return S_OK;
#endif
}

/**********************************************************************//**
 *
 * Cg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	Index	= CgCfbNX
 * @param [in]	pLight	= Cg
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetLight(DWORD Index, CONST LPDXLIGHT pLight)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->SetLight(Index, pLight);
#else
	return m_object->SetLight(Index, pLight, D3DMFMT_D3DMVALUE_FIXED);
#endif
}

/**********************************************************************//**
 *
 * Cg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Index	= CgCfbNX
 * @param [out]	pLight	= Cg
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetLight(DWORD Index, LPDXLIGHT pLight)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->GetLight(Index, pLight);
#else
	D3DMFORMAT format;
	return m_object->GetLight(Index, pLight, &format);
#endif
}

/**********************************************************************//**
 *
 * }eA̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pMaterial	= }eA
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::SetMaterial(CONST LPDXMATERIAL pMaterial)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->SetMaterial(pMaterial);
#else
	return m_object->SetMaterial(pMaterial, D3DMFMT_D3DMVALUE_FIXED);
#endif
}

/**********************************************************************//**
 *
 * }eA̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pMaterial	= }eA
 * @return	
*//***********************************************************************/
HRESULT	CDXIDevice::GetMaterial(LPDXMATERIAL pMaterial)
{
	if( m_object == nullptr ) return E_POINTER;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_object->GetMaterial(pMaterial);
#else
	D3DMFORMAT format;
	return m_object->GetMaterial(pMaterial, &format);
#endif
}

}	// end of namespace intr
}	// end of namespace dx
}	// end of namespace iris

