//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMatrix.cpp
 * @brief		directX }gbNXvZ⏕֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMatrix_CPP_

//======================================================================
// include
#include "DXMatrix.h"

namespace iris {
namespace dx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * }gbNX̐
 *
 ----------------------------------------------------------------------
 * @param [out]	pmat	= o̓}gbNX
 * @param [in]	pvecPos	= ʒu
 * @param [in]	pvecRot	= ]
 * @param [in]	pvecScal= XP[
 * @return	pmat
*//***********************************************************************/
D3DXMATRIX*	CreateMatrix(D3DXMATRIX *pmat
	, const D3DXVECTOR3 *pvecPos
	, const D3DXVECTOR3 *pvecRot
	, const D3DXVECTOR3 *pvecScal)
{
	D3DXMatrixRotationYawPitchRoll( pmat, (f32)D3DXToRadian(pvecRot->y), (f32)D3DXToRadian(pvecRot->x), (f32)D3DXToRadian(pvecRot->z) );
	pmat->_11 *= pvecScal->x;
	pmat->_12 *= pvecScal->x;
	pmat->_13 *= pvecScal->x;

	pmat->_21 *= pvecScal->y;
	pmat->_22 *= pvecScal->y;
	pmat->_23 *= pvecScal->y;

	pmat->_31 *= pvecScal->z;
	pmat->_32 *= pvecScal->z;
	pmat->_33 *= pvecScal->z;

	pmat->_41 = pvecPos->x;
	pmat->_42 = pvecPos->y;
	pmat->_43 = pvecPos->z;
	pmat->_44 = 1.0f;
	return pmat;
}

}	// end of namespace dx
}	// end of namespace iris
