//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXVPad.h
 * @brief		directX zRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXVPad_H_
#define INCG_IRIS_DXVPad_H_

//======================================================================
// include
#include "DXKeyState.h"

namespace iris {
namespace dx
{

//======================================================================
// enum
//! AiOXeBbNCfbNX
typedef enum eDXVANALOGPAD
{
	eDXVALGPAD_L,	//!< XeBbN
	eDXVALGPAD_R,	//!< EXeBbN
	eDXVALGPAD_NUM
} eDXVANALOGPAD;
//! L[CfbNX
typedef enum eDXVPAD
{
	eDXVPAD_BUTTON_UP,			//!< 
	eDXVPAD_BUTTON_DOWN,		//!< 
	eDXVPAD_BUTTON_LEFT,		//!< 
	eDXVPAD_BUTTON_RIGHT,		//!< E
	eDXVPAD_BUTTON_CIRCLE,		//!< 
	eDXVPAD_BUTTON_CROSS,		//!< ~
	eDXVPAD_BUTTON_SQUARE,		//!< 
	eDXVPAD_BUTTON_TRIANGLE,	//!< 
	eDXVPAD_L1,					//!< L1
	eDXVPAD_L2,					//!< L2
	eDXVPAD_L3,					//!< L3
	eDXVPAD_R1,					//!< R1
	eDXVPAD_R2,					//!< R2
	eDXVPAD_R3,					//!< R3
	eDXVPAD_BUTTON_START,		//!< START
	eDXVPAD_BUTTON_SELECT,		//!< SELECT
	eDXVPAD_BUTTON_HOME,		//!< HOME

	eDXVPAD_NUM
} eDXVPAD;
//! L[}XN
typedef enum DXVPAD
{
	DXVPAD_BUTTON_UP		= 1<<eDXVPAD_BUTTON_UP,			//!< 
	DXVPAD_BUTTON_DOWN		= 1<<eDXVPAD_BUTTON_DOWN,		//!< 
	DXVPAD_BUTTON_LEFT		= 1<<eDXVPAD_BUTTON_LEFT,		//!< 
	DXVPAD_BUTTON_RIGHT		= 1<<eDXVPAD_BUTTON_RIGHT,		//!< E
	DXVPAD_BUTTON_CIRCLE	= 1<<eDXVPAD_BUTTON_CIRCLE,		//!< 
	DXVPAD_BUTTON_CROSS		= 1<<eDXVPAD_BUTTON_CROSS,		//!< ~
	DXVPAD_BUTTON_SQUARE	= 1<<eDXVPAD_BUTTON_SQUARE,		//!< 
	DXVPAD_BUTTON_TRIANGLE	= 1<<eDXVPAD_BUTTON_TRIANGLE,	//!< 
	DXVPAD_L1				= 1<<eDXVPAD_L1,				//!< L1
	DXVPAD_L2				= 1<<eDXVPAD_L2,				//!< L2
	DXVPAD_L3				= 1<<eDXVPAD_L3,				//!< L3
	DXVPAD_R1				= 1<<eDXVPAD_R1,				//!< R1
	DXVPAD_R2				= 1<<eDXVPAD_R2,				//!< R2
	DXVPAD_R3				= 1<<eDXVPAD_R3,				//!< R3
	DXVPAD_BUTTON_START		= 1<<eDXVPAD_BUTTON_START,		//!< START
	DXVPAD_BUTTON_SELECT	= 1<<eDXVPAD_BUTTON_SELECT,		//!< SELECT
	DXVPAD_BUTTON_HOME		= 1<<eDXVPAD_BUTTON_HOME,		//!< HOME

	DXVPAD_TERM
} DXVPAD;

//======================================================================
// declare

//======================================================================
// typedef

//======================================================================
// class

//======================================================================
//! zRg[[NX
class CDXVPad : public INonCopyable<>
{
protected:
	u32			m_Hold;		//!< 
	u32			m_Trig;		//!< u
	u32			m_Free;		//!< u
	u32			m_Rept;		//!< s[g

	//! L[擾
	CKeyState*			m_pKeys[eDXVPAD_NUM];
	//! joy
	CDXJoyStickState*	m_pJoys[eDXVALGPAD_NUM];
public:
	// RXgN^
	CDXVPad(void);
	// fXgN^
	virtual ~CDXVPad(void);
public:
	// XV
	void	Update(void);

public:
	// L[̊蓖
	CKeyState*			SetKey(int nIndex, CKeyState* pKey);
	CDXJoyStickState*	SetJoy(int nIndex, CDXJoyStickState* pJoy);
	// L[擾
	u32				Hold(void)	{ return m_Hold; }	//!< get m_Hold.
	u32				Trig(void)	{ return m_Trig; }	//!< get m_Trig.
	u32				Free(void)	{ return m_Free; }	//!< get m_Free.
	u32				Rept(void)	{ return m_Rept; }	//!< get m_Rept.
	f32				AlgX(int nIndex);
	f32				AlgY(int nIndex);
	f32				AlgZ(int nIndex);
	D3DXVECTOR3*	Alg(int nIndex);
	// L[NA
	void			Clear(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
