//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMusicSegment.cpp
 * @brief		directX MusicSegment t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMusicSegment_CPP_

//======================================================================
// include
#include "DXMusicSegment.h"

#ifdef _IRIS_DX_SUPPORT_DXMUSIC

//======================================================================
// link
#pragma comment ( lib, "dxguid.lib" )

namespace iris {
namespace dx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	pPerformance	= IDirectMusicPerformance8
 * @param [in]	pSegment		= IDirectMusicSegment8
*//***********************************************************************/
CDXMusicSegment::CDXMusicSegment(IDirectMusicPerformance8 *pPerformance, IDirectMusicSegment8 *pSegment)
: m_pPerformance(pPerformance)
, m_pSegment(pSegment)
, m_pAudioPath(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMusicSegment::~CDXMusicSegment(void)
{
}

/**********************************************************************//**
 *
 * tJn
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags			= ~^C𒲐tO
 * @param [in]	pAudioPath		= IDirectMusicAudioPath8IuWFNg
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::PlayEx(DWORD dwFlags, IDirectMusicAudioPath8* pAudioPath)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	IUnknown *pUnknown = pAudioPath;
	// I[fBIpXw肳ĂȂꍇ͖ߍ܂ĂI[fBIpXgp
	if( pUnknown == nullptr ) pUnknown = m_pAudioPath;
	// ߍ܂ĂI[fBIpXȂꍇ̓ftHg̃I[fBIpXgp
	if( pUnknown == nullptr ) pUnknown = nullptr;
	// Đ
	return m_pPerformance->PlaySegmentEx(m_pSegment, nullptr, nullptr
		, dwFlags, 0, nullptr, nullptr, pAudioPath);
}

/**********************************************************************//**
 *
 * t~
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags	= ~^C𒲐tO
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::StopEx(DWORD dwFlags)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->StopEx(m_pSegment, 0, dwFlags);
}

/**********************************************************************//**
 *
 * tׂ
 *
 ----------------------------------------------------------------------
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::IsPlaying(void)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->IsPlaying(m_pSegment, nullptr);
}

/**********************************************************************//**
 *
 * g`̃_E[h
 *
 ----------------------------------------------------------------------
 * @param [in]	pAudioPath	= IDirectMusicAudioPath8IuWFNg
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::Download(IDirectMusicAudioPath8 *pAudioPath)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	IUnknown *pUnknown = pAudioPath;
	// I[fBIpXw肳ĂȂꍇ͖ߍ܂ĂI[fBIpXgp
	if( pUnknown == nullptr ) pUnknown = m_pAudioPath;
	// ߍ܂ĂI[fBIpXȂꍇ̓ptH[}Xgp
	if( pUnknown == nullptr ) pUnknown = m_pPerformance;
	return m_pSegment->Download( pUnknown );
}

/**********************************************************************//**
 *
 * g`̃A[h
 *
 ----------------------------------------------------------------------
 * @param [in]	pAudioPath	= IDirectMusicAudioPath8IuWFNg
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::Unload( IDirectMusicAudioPath8 *pAudioPath /*= nullptr*/ )
{
	if( m_pSegment == nullptr ) return S_FALSE;
	HRESULT		hr			= S_FALSE;
	IUnknown	*pUnknown	= pAudioPath;
	// ~
	if( m_pPerformance ) hr = StopEx();
	// I[fBIpXw肳ĂȂꍇ͖ߍ܂ĂI[fBIpXgp
	if( pUnknown == nullptr ) pUnknown = m_pAudioPath;
	// ߍ܂ĂI[fBIpXȂꍇ̓ptH[}Xgp
	if( pUnknown == nullptr ) pUnknown = m_pPerformance;
	hr = m_pSegment->Unload( pUnknown );
	IRIS_SAFE_RELEASE( m_pSegment );
	return hr;
}

/**********************************************************************//**
 *
 * [v񐔂̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwRepeats	= [v
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::SetRepeats(DWORD dwRepeats)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->SetRepeats( dwRepeats );
}

/**********************************************************************//**
 *
 * [v񐔂̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pdwRepeats	= [v
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::GetRepeats(LPDWORD pdwRepeats)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->GetRepeats( pdwRepeats );
}

/**********************************************************************//**
 *
 * t̊Jnʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lStart	= Jnʒu
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::SetStartPoint(LONG lStart)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->SetStartPoint( lStart );
}

/**********************************************************************//**
 *
 * t̊Jnʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	plStart	= Jnʒu
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::GetStartPoint(PLONG plStart)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->GetStartPoint( plStart );
}

/**********************************************************************//**
 *
 * Ȃ̒̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lLength	= Ȃ̒
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::SetLength(LONG lLength)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->SetLength( lLength );
}

/**********************************************************************//**
 *
 * Ȃ̒̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	plLength	= Ȃ̒
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusicSegment::GetLength(PLONG plLength)
{
	if( m_pSegment == nullptr ) return S_FALSE;
	return m_pSegment->GetLength( plLength );
}

}	// end of namespace dx
}	// end of namespace iris

#endif	// #ifdef _IRIS_DX_SUPPORT_DXMUSIC
