//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSound.cpp
 * @brief		directX TEhfoCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXSound_CPP_

//======================================================================
// include
#include "DXSound.h"
#include "audio/format/wav/AXWavFile.h"
#include "../DXError.h"

#include "iris_debug.h"

//======================================================================
// link
#pragma comment ( lib, "dsound.lib" )
#pragma comment ( lib, "dxguid.lib" )

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// CDXSound
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXSound::CDXSound(void)
: m_pDxSound(nullptr)
, m_pPrimaryBuffer(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXSound::~CDXSound(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= 
 * @param [in]	dwCoopLevel	= x(DSSCL_***)
 * @return	
*//***********************************************************************/
HRESULT	CDXSound::Initialize(HWND hWnd, DWORD dwCoopLevel)
{
	if( m_pDxSound != nullptr ) return S_FALSE;
	HRESULT hr=S_OK;
	// 
	hr = DXSoundCreate( nullptr, &m_pDxSound, nullptr );
	if(FAILED(hr)) { DX_ERROR(hr); return hr; }
	// x̐ݒ
	hr = m_pDxSound->SetCooperativeLevel( hWnd, dwCoopLevel );
	if(FAILED(hr)) { DX_ERROR(hr); return hr; }
	return hr;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXSound::Release(void)
{
	DX_SAFE_RELEASE( m_pPrimaryBuffer );
	DX_SAFE_RELEASE( m_pDxSound );
}

/**********************************************************************//**
 *
 * vC}obt@̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags	= tO(DSBCAPS_***)
 * @return	
*//***********************************************************************/
HRESULT	CDXSound::CreatePrimaryBuffer(DWORD dwFlags)
{
	HRESULT hr = S_OK;
	DSBUFFERDESC dsbdesk = {0};
	dsbdesk.dwSize = sizeof(DSBUFFERDESC);
	dsbdesk.dwFlags = DSBCAPS_PRIMARYBUFFER|dwFlags; // vC}obt@
	hr = m_pDxSound->CreateSoundBuffer( &dsbdesk, &m_pPrimaryBuffer, nullptr );
	if( FAILED(hr) ) { DX_ERROR(hr); }
	return hr;
}

/**********************************************************************//**
 *
 * WAVEt@C̓ǂݍ
 *			TEhobt@̍쐬AWAVEt@CNX͕܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	pSound			= 쐬Ώ
 * @param [in]	pFileName		= t@C
 * @param [in]	dwFlags			= tO(DSBCAPS_***)
 * @param [in]	guid3DAlgorithm	= 
 * @param [in]	dwNumBuffers	= obt@
 * @return	
*//***********************************************************************/
HRESULT CDXSound::LoadSoundFile(CDXSoundBuffer* pSound
	, LPTSTR pFileName
	, DWORD dwFlags
	, GUID guid3DAlgorithm
	, DWORD dwNumBuffers )
{
#ifdef UNICODE
	return LoadSoundFileW(pSound, pFileName, dwFlags, guid3DAlgorithm, dwNumBuffers);
#else
	return LoadSoundFileA(pSound, pFileName, dwFlags, guid3DAlgorithm, dwNumBuffers);
#endif
}
/// CDXSound::LoadSoundFile Q
HRESULT CDXSound::LoadSoundFileA(CDXSoundBuffer* pSound
	, LPSTR	pFileName
	, DWORD dwFlags
	, GUID guid3DAlgorithm
	, DWORD dwNumBuffers )
{
	ax::CWavFile wave;
	if( !wave.OpenA( pFileName ) ) return S_FALSE;
	return CreateSoundFile(pSound, &wave, dwFlags, guid3DAlgorithm, dwNumBuffers);
}
/// CDXSound::LoadSoundFile Q
HRESULT CDXSound::LoadSoundFileW(CDXSoundBuffer* pSound
	, LPWSTR pFileName
	, DWORD dwFlags
	, GUID guid3DAlgorithm
	, DWORD dwNumBuffers )
{
	ax::CWavFile wave;
	if( !wave.OpenW( pFileName ) ) return S_FALSE;
	return CreateSoundFile(pSound, &wave, dwFlags, guid3DAlgorithm, dwNumBuffers);
}

/**********************************************************************//**
 *
 * TEhobt@̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	pSound			= 쐬Ώ
 * @param [in]	pSoundFile		= WAVEt@C(Openς)
 * @param [in]	dwFlags			= tO(DSBCAPS_***)
 * @param [in]	guid3DAlgorithm	= 
 * @param [in]	dwNumBuffers	= obt@
 * @return	
*//***********************************************************************/
HRESULT CDXSound::CreateSoundFile(CDXSoundBuffer* pSound
								  , ax::IAXFile* pSoundFile
								  , DWORD dwFlags
								  , GUID guid3DAlgorithm
								  , DWORD dwNumBuffers )
{
	if( pSound == nullptr )		return S_FALSE;
	if( pSoundFile == nullptr )	return S_FALSE;
	HRESULT				hr			= S_OK;	// G[擾p
	DSBUFFERDESC		dsbd		= {0};	// DSBUFFERDESC\
	LPDIRECTSOUNDBUFFER	pBuffer	= nullptr;	// TEhobt@IuWFNg
	WAVEFORMATEX		wfex		= {0};

	if( pSound->CreateBuffer( dwNumBuffers ) != S_OK )	return S_FALSE;

	pSoundFile->GetWaveFormatEx(&wfex);
	dsbd.dwSize				= sizeof( dsbd );// \̂̃TCY
	dsbd.dwFlags			= dwFlags;// ʃtO
	dsbd.dwReserved			= 0;
	dsbd.dwBufferBytes		= pSoundFile->GetSize();// obt@TCY
	dsbd.lpwfxFormat		= &wfex;// WAVEtH[}bg\̂̃AhX
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	dsbd.guid3DAlgorithm	= guid3DAlgorithm;
#endif

	hr = m_pDxSound->CreateSoundBuffer(&dsbd, &pBuffer, nullptr);
	if( FAILED( hr ) )
		goto exit;

	// C^[tFCX̊i[
	hr = pBuffer->QueryInterface(IID_DXSOUNDBUFFER, (void**)pSound->GetBuffer( 0 ));
	DX_SAFE_RELEASE( pBuffer );
	if( FAILED( hr ) )	goto exit;

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( ( dwFlags & DSBCAPS_CTRLFX ) == 0 )
	{
		for( DWORD i = 1; i < dwNumBuffers; ++ i )
		{
			hr = DuplicateSoundBuffer(*pSound->GetBuffer( 0 ), pSound->GetBuffer( i ));
			if( FAILED( hr ) )	goto exit;
		}
	}
	else
#endif
	{
		for( DWORD i = 1; i < dwNumBuffers; ++ i )
		{
			hr = m_pDxSound->CreateSoundBuffer(&dsbd, &pBuffer, nullptr);
			if( FAILED( hr ) )	goto exit;

			// C^[tFCX̊i[
			hr = pBuffer->QueryInterface(IID_DXSOUNDBUFFER, (void**)pSound->GetBuffer( i ));
			DX_SAFE_RELEASE( pBuffer );
			if( FAILED( hr ) )	goto exit;
		}
	}

	pSound->SetSoundFile(pSoundFile);
	hr = pSound->FillBuffer( *pSound->GetBuffer( 0 ) );
	if( FAILED( hr ) )	goto exit;
	return hr;

exit:
	DX_ERROR(hr);
	pSound->Release();
	return hr;
}

/**********************************************************************//**
 *
 * obt@̕
 *
 ----------------------------------------------------------------------
 * @param [in]	pDSBufferOriginal	= 
 * @param [in]	ppDSBufferDuplicate	= o
 * @return	
*//***********************************************************************/
HRESULT CDXSound::DuplicateSoundBuffer(LPDXSOUNDBUFFER pDSBufferOriginal
									 , LPDXSOUNDBUFFER* ppDSBufferDuplicate )
{
	if( m_pDxSound == nullptr )				return S_FALSE;
	if( pDSBufferOriginal == nullptr )		return S_FALSE;
	if( ppDSBufferDuplicate == nullptr )	return S_FALSE;

	HRESULT				hr			= S_OK;// G[擾p
	IDirectSoundBuffer	*pBuffer	= nullptr;// IDirectSoundBufferIuWFNg

	hr = m_pDxSound->DuplicateSoundBuffer(pDSBufferOriginal, &pBuffer);
	if( FAILED( hr ) ) { DX_ERROR(hr); return hr; }

	hr = pBuffer->QueryInterface(IID_DXSOUNDBUFFER, (void**)ppDSBufferDuplicate);
	DX_SAFE_RELEASE( pBuffer );

	if( FAILED( hr ) ) { DX_ERROR(hr); }
	return hr;
}

//**********************************************************************
//
// wrap
//
//**********************************************************************
HRESULT CDXSound::SetPrimaryVolume(LONG lVolume)	
{
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE; 
	return m_pPrimaryBuffer->SetVolume(lVolume); 
}
HRESULT CDXSound::GetPrimaryVolume(PLONG plVolume)	
{
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE;
	return m_pPrimaryBuffer->GetVolume(plVolume); 
}
HRESULT CDXSound::SetPrimaryPan(LONG lPan)
{ 
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE;
	return m_pPrimaryBuffer->SetPan(lPan);
}
HRESULT CDXSound::GetPrimaryPan(PLONG plPan)
{
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE;
	return m_pPrimaryBuffer->GetPan(plPan);
}
HRESULT CDXSound::SetPrimaryFormat(LPCWAVEFORMATEX pwfx)
{
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE;
	return m_pPrimaryBuffer->SetFormat(pwfx);
}
HRESULT CDXSound::GetPrimaryFormat(LPWAVEFORMATEX  pwfx, DWORD dwSizeAlloced, LPDWORD pdwSizeWirtten)
{
	if( m_pPrimaryBuffer == nullptr ) return S_FALSE;
	return m_pPrimaryBuffer->GetFormat(pwfx, dwSizeAlloced, pdwSizeWirtten);
}


}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../win/debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"

#define WINDOW_STYLE	( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX )
#define WINDOW_STYLEEX	( WS_EX_OVERLAPPEDWINDOW )

//======================================================================
// function

//======================================================================
// test
IRIS_UNITTEST(CDXSoundUnitTest, DXSoundUnitTest)
{
	TCHAR*		pName	= TEXT("sample");
	HINSTANCE hInstance = (HINSTANCE)GetModuleHandle(nullptr);

	// EBhE̍쐬
	HWND hWnd = ::wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX
		, pName
		, pName
		, WINDOW_STYLE);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	// EBhE`
	ShowWindow( hWnd, SW_SHOW );
	// őOʂ
	SetForegroundWindow(hWnd);

	// EBhE̍XV
	UpdateWindow( hWnd );

	CDXSound		ds;
	CDXSoundBuffer	sound;

	// DirectSound̏
	ds.Initialize( hWnd );

	// WAVEt@C̓ǂݍ
	DX_CHECK_RESULT( ds.LoadSoundFile(&sound, TEXT("../../data/snd/sample.wav")) );

	// WAVEt@C̍Đ
	DX_CHECK_RESULT(sound.Play());

	wx::dbg::UnitTestMainLoop(hWnd);

	// WAVEt@C̒~
	sound.Stop();

	// nullptrn
	sound.SetSoundFile( nullptr );

	// WAVEt@C̉
	sound.Release();

	// DirectSound̉
	ds.Release();

	UnregisterClass(pName, hInstance);
}

#endif	// (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
