//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MfcArrayEx.h
 * @brief		g Array t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MfcArrayEx_H_
#define INCG_IRIS_MfcArrayEx_H_

//======================================================================
// include
#include "fnd/container/FndVaugeOperator.h"
#include "iris_debug.h"
#include "afxtempl.h"

namespace iris {
namespace mfc
{

//======================================================================
// class

/**
 * @brief	gzNX
 * @tparam	TYPE		= i[^
 * @tparam	ARG_TYPE	= TYPE ̈p̌^
*/
template<class TYPE, class ARG_TYPE = const TYPE&>
class CArrayEx : public CArray<TYPE, ARG_TYPE>
{
	typedef CArrayEx<TYPE, ARG_TYPE>	_Myt;
	typedef CArray<TYPE, ARG_TYPE>		_Mybase;
protected:

public:
	// rIuWFNg
	struct SLess
	{
		int	operator () (ARG_TYPE lhs, ARG_TYPE rhs)	const	{ return lhs < rhs ? -1 : 1; }
	};
	struct SLEqual
	{
		int	operator () (ARG_TYPE lhs, ARG_TYPE rhs)	const	{ return lhs <= rhs ? -1 : 1; }
	};
	struct SGreator
	{
		int	operator () (ARG_TYPE lhs, ARG_TYPE rhs)	const	{ return lhs > rhs ? -1 : 1; }
	};
	struct SGEqual
	{
		int	operator () (ARG_TYPE lhs, ARG_TYPE rhs)	const	{ return lhs >= rhs ? -1 : 1; }
	};

public:
	/**
	 * @brief	\[g
	*/
	template<class _COMP>
	void	Sort(void)
	{
		qsort(GetData(), GetSize(), sizeof(TYPE), Compare<_COMP>);
	}

private:
	/**
	 * @internal
	 * @brief r֐
	*/
	template<class _COMP>
	static int __cdecl Compare(const void* elem1, const void* elem2)
	{
		IRIS_ASSERT( elem1 != nullptr );
		IRIS_ASSERT( elem2 != nullptr );
		static const _COMP comp;
		return comp(*reinterpret_cast<const TYPE*>(elem1), *reinterpret_cast<const TYPE*>(elem2));
	}
};

}	// end of namespace mfc
}	// end of namespace iris

#endif
