//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MfcSortArray.h
 * @brief		SortArray t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MfcSortArray_H_
#define INCG_IRIS_MfcSortArray_H_

//======================================================================
// include
#include "MfcArrayEx.h"
#include "iris_debug.h"

namespace iris {
namespace mfc
{

//======================================================================
// class
/**
 * @brief	\[gzNX
 * @tparam	TYPE		= i[^
 * @tparam	COMPARE		= rIuWFNg
 * @tparam	ARG_TYPE	= TYPE ̈p̌^
*/
template<class TYPE, class COMPARE, class ARG_TYPE = const TYPE&>
class CSortArray : public CArrayEx<TYPE, ARG_TYPE>
{
	typedef CSortArray<TYPE, COMPARE, ARG_TYPE>	_Myt;
	typedef CArrayEx<TYPE, ARG_TYPE>			_Mybase;
protected:
	
public:
	/**
	 * @brief	vfǉ
	 * @param [in]	newElement	= ǉvf̒l
	 * @return ǉꂽCfbNX
	*/
	INT_PTR Add(ARG_TYPE newElement)
	{
		COMPARE comp;
		INT_PTR s = 0;
		INT_PTR e = m_nSize-1;
		INT_PTR n = s + ((m_nSize-s)>>1);
		while(s<=e)
		{
			const TYPE& temp = GetAt(n);
			if( comp(newElement, temp) > 0 )	s = n+1;
			else								e = n-1;
			n = s + ((e-s+1)>>1);
		}
		_Mybase::InsertAt(s, newElement);
		return s;
	}
	/**
	 * @brief	vf}
	*/
	void InsertAt(INT_PTR nIndex, ARG_TYPE newElement, INT_PTR nCount = 1)
	{
		_Mybase::InsertAt(nIndex, newElement, nCount);
		Sort();
	}

	/**
	 * @brief	w̗vfύX
	 * @param [in]	nIndex		= vf̃CfbNX
	 * @param [in]	newElement	= Vvf̒l
	*/
	void SetAt(INT_PTR nIndex, ARG_TYPE newElement)
	{
#if 0
		// ύX̂Ƃlă\[g
		RemoveAt(nIndex);
		Add(newElement);
#else
		// ̈qɂāAтĂ邱Ƃl
		_Mybase::SetAt(nIndex, newElement);
		Sort();
#endif
	}

public:
	/**
	 * @brief \[g
	*/
	void	Sort(void)
	{
		_Mybase::Sort<COMPARE>();
	}
};

}	// end of namespace mfc
}	// end of namespace iris

#endif
