//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MDIDocument.h
 * @brief		MDIhLgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMDIDocument_H_
#define INCG_IRIS_WXMDIDocument_H_

//======================================================================
// include
#include "WXWindow.h"

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// macros
// MDIhLg̃Cxg
#define __IrisDocEventFuncName( name ) OnDoc##name
// MDIhLg̃Cxg
#define __IrisDocEventFunc( name )					\
	virtual LRESULT __IrisDocEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)
// MDIhLg֐̈warning̏p
#define __IrisDocEventUnusedVariable()				\
	IRIS_UNUSED_VARIABLE(hWnd);	IRIS_UNUSED_VARIABLE(wParam); IRIS_UNUSED_VARIABLE(lParam)
// MDĨCxg`
#define __IrisDocEventFuncImpl( cls, name )			\
	LRESULT cls::__IrisDocEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)

//======================================================================
// class
//! MDIhLgx[XNX
class CMDIDocument : public CWindow
{
public:
	typedef struct DOCPARAMS
	{
		u32		cbSize;
		LPARAM	lParam;
	} DOCPARAMS, *LPDOCPARAMS;
public:
	// RXgN^
	CMDIDocument(HWND hWnd, LPDOCPARAMS pDocParam);
	// fXgN^
	virtual ~CMDIDocument(void);

public:
	//! XV
	virtual void	Transaction(void);

public:

	// Cxgnh
	// 0 ԂƃftHgEBhEvV[WR[Ȃ
	__IrisDocEventFunc(Create)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Destroy)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Move)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Size)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Activate)		{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(SetFocus)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(KillFocus)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Enable)			{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(Paint)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Close)			{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(EraseBkGnd)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(ShowWindow)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SetCursor)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MouseActivate)	{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(ChildActivate)	{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(GetMinMaxInfo)	{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(DrawItem)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MeasureItem)		{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(Notify)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Help)			{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(KeyDown)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(KeyUp)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Char)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(DeadChar)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SysKeyDown)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SysKeyUp)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SysChar)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SysDeadChar)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(KeyLast)			{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(Command)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(SysCommand)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(Timer)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(HScroll)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(VScroll)			{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MenuSelect)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MenuChar)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(EnterMenuLoop)	{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(ExitMenuLoop)	{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(MouseMove)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(LButtonDown)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(LButtonUp)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(LButtonDblClk)	{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(RButtonDown)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(RButtonUp)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(RButtonDblClk)	{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MButtonDown)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MButtonUp)		{ __IrisDocEventUnusedVariable(); return 1; }
	__IrisDocEventFunc(MButtonDblClk)	{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(MDIActivate)		{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(DropFiles)		{ __IrisDocEventUnusedVariable(); return 1; }

	__IrisDocEventFunc(DrawClipboard)	{ __IrisDocEventUnusedVariable(); return 1; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
