//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHandle.h
 * @brief		nhx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHandle_H_
#define INCG_IRIS_WXHandle_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! nhNXC^[tFCX
class IHandle : public IIrisObject
{
public:
	virtual ~IHandle(void) {}
public:
	virtual	BOOL	Close(void) = 0;
};

//! nhNX
class CHandle : public IHandle, public INonCopyable<CHandle>
{
protected:
	HANDLE	m_hObject;			//!< nh
public:
	/// RXgN^
	CHandle(void)
		: m_hObject(nullptr)		{}
	/// RXgN^
	CHandle(HANDLE hObject)
		: m_hObject(nullptr)		{ Attach(hObject); }
	
	/// fXgN^
	virtual ~CHandle(void)			{ Close(); }

	HANDLE					GetHandle(void)		{ return m_hObject; }
				operator	HANDLE (void)		{ return GetHandle(); }
	HANDLE		operator	() (void)			{ return GetHandle(); }
	CHandle&	operator	= (HANDLE hdl)		{ Attach(hdl); return *this; }
	
public:
	/// nh֘At
	BOOL	Attach(HANDLE hObject)
	{
		if( hObject == nullptr || m_hObject != nullptr ) return FALSE;
		m_hObject = hObject;
		return TRUE;
	}
	/// nh̊֘At
	HANDLE	Detach(void)
	{
		HANDLE hPre = m_hObject;
		m_hObject = nullptr;
		return hPre;
	}
	/// ֘At̎s
	BOOL	TryAttach(HANDLE hObject)
	{
		if( Attach(hObject) ) return TRUE;
		CloseHandle(hObject);
		return FALSE;
	}

public:
	/// Lȃnhǂ
	BOOL	IsValid(void)	const	{ return (m_hObject != nullptr && m_hObject != INVALID_HANDLE_VALUE) ? TRUE : FALSE; }

public:
#if	!defined(IRIS_WIN32_WCE)
	/// nh̎擾
	BOOL	GetInformation(LPDWORD lpdwFlags)			const	{ return ::GetHandleInformation(m_hObject, lpdwFlags); }
	/// nh̐ݒ
	BOOL	SetInformation(DWORD dwMask, DWORD dwFlags)			{ return ::SetHandleInformation(m_hObject, dwMask, dwFlags); }
#endif

public:
#if	!defined(IRIS_WIN32_WCE)
	/// nh݂Ă邩
	virtual BOOL	IsExist(void)	const	{ if( !IsValid() ) return false; DWORD dwFlags=0; return GetInformation(&dwFlags); }
#else
	virtual BOOL	IsExist(void)	const	{ return IsValid(); }
#endif

public:
	/// 
	virtual	BOOL	Close(void)				{ return CloseHandle( Detach() ); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
