//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDockingWindow.h
 * @brief		hbLOEBhENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDockingWindow_H_
#define INCG_IRIS_WXDockingWindow_H_

//======================================================================
// include
#include "WXFrameWindow.h"
#include "WXTabCtrl.h"
#include <vector>

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
class CDockableWindow;
class CDockingFrameWindow;

//======================================================================
// class
//! hbLO\EBhE
class CDockableWindow : public CWindow
{
public:
	typedef enum
	{
		DIR_LEFT	= 0,
		DIR_TOP,
		DIR_RIGHT,
		DIR_BOTTOM,
		DIR_NUM
	} DIRECTION;
protected:
	typedef std::vector<CWindow*>	CDockList;
private:
	CDockableWindow*	m_pParent;			//!< e
	int					m_Direction;		//!< AĂie_j
	CDockableWindow*	m_pJoin[DIR_NUM];	//!< AĂEBhE
	CDockList			m_List;				//!< hbLOĂEBhE
	int					m_NcHitTest;		//!< hit test
	POINT				m_MaxTrackSize;		//!< őTCY
	CTabCtrl			m_Tab;				//!< ^uEBhE

public:
	// RXgN^
	CDockableWindow(void);
	// fXgN^
	virtual ~CDockableWindow(void);

public:
	// EBhE̍쐬
	virtual HWND	Create(LPCTSTR lpszWindowName
						, const RECT& rRect
						, HWND hWndParent
						, HINSTANCE hInstance
						, void* pParam = nullptr);

public:
	// hbLOEBhEA
	virtual bool	Joint(int dir, CDockableWindow* pDock);

	// EBhEgɃhbLO
	virtual	bool	Docking(CWindow* pWindow);

public:
	/// AĂEBhE擾
	CDockableWindow*	GetJointWindow(int dir)			{ return m_pJoin[dir]; }
	/// AĂ\ݒEBhE擾
	CDockableWindow*	GetVisibleJointWindow(int dir);
	/// 擾
	CDockableWindow*	GetLeft(void)		{ return m_pJoin[DIR_LEFT]; }
	/// 擾
	CDockableWindow*	GetTop(void)		{ return m_pJoin[DIR_TOP]; }
	/// E擾
	CDockableWindow*	GetRight(void)		{ return m_pJoin[DIR_RIGHT]; }
	/// 擾
	CDockableWindow*	GetBottom(void)		{ return m_pJoin[DIR_BOTTOM]; }

	// t[EBhENX̎擾
	CDockingFrameWindow*	GetFrameWindow(void);
	// 
	CDockableWindow*	Find(CWindow* pWindow);

public:
	// EBhETCY
	BOOL	SetWindowPos(int x, int y, int w, int h, BOOL bRepaint);

public:
	// hbLOĂ邩ǂ
	bool	IsDocking(void);
	bool	IsDocking(CWindow* pWindow);
	// hbLOĂ邩ǂ
	bool	IsHasChild(void);
	// hbLOꂢ  \ݒ̃EBhE邩ǂ
	bool	IsHasVisibleChild(void);

protected:
	// ^Cgݒ
	void	SetTitle(CWindow* pWindow);

protected:
	// ^uEBhE̍쐬
	virtual bool	CreateTabWindow(void);
protected:
    // EBhEvV[W
	virtual LRESULT WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	// on WM_NCHITTEST
	virtual LRESULT OnNcHitTest		(HWND hWnd, WPARAM wParam, LPARAM lParam);
	// on WM_MINMAXINFO
	virtual LRESULT OnMinMaxInfo	(HWND hWnd, WPARAM wParam, LPARAM lParam);
	// on WM_SIZE
	virtual LRESULT OnSize			(HWND hWnd, WPARAM wParam, LPARAM lParam);
	// on WM_SIZE
	virtual LRESULT OnNotify		(HWND hWnd, WPARAM wParam, LPARAM lParam);
	// on WM_CLOSE
	virtual LRESULT OnClose			(HWND hWnd, WPARAM wParam, LPARAM lParam);
};

//! hbLOeEBhENX
class CDockingFrameWindow : public CFrameWindow
{
private:
	CDockableWindow		m_root;	//!< [g
public:
	// RXgN^
	CDockingFrameWindow(void);
	// fXgN^
	~CDockingFrameWindow(void);

public:
	// hbLO\ǂ
	virtual bool				IsDockable(CWindow* pWindow);
	// hbLOEBhEo^
	virtual CDockableWindow*	Dockable(CWindow* pWindow);
	// hbLO
	virtual bool				Docking(CDockableWindow* pDock, CWindow* pWindow);
	// WCg
	virtual bool				Joint(CDockableWindow* pParent, int dir, CDockableWindow* pWindow);
	virtual bool				Joint(int dir, CDockableWindow* pWindow)	{ return Joint(&m_root, dir, pWindow); }
	// hbLOEBhĚ
	virtual CDockableWindow*	Find(CWindow* pWindow);

public:
	// \ݒ
	BOOL	ShowDockableWindow(CWindow* pWindow, int nShowCmd);

public:
	// TCYݒ̃Zbg
	BOOL	CallSetDockableWindowPos(void);

protected:
    // EBhEvV[W
	virtual LRESULT WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
public:
	// Cxg
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
protected:
	// o^ĂhbLOEBhE
	void	RelaseDockableWindow(void);
	void	RelaseDockableWindow(CDockableWindow* pWindow);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
