//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPropertySheet.h
 * @brief		vpeBV[gNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPropertySheet_H_
#define INCG_IRIS_WXPropertySheet_H_

//======================================================================
// include
#include "../app/WXSubClass.h"
#include "WXPropertySheetPage.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// vpeBV[gNX
class CPropertySheet : public CSubClass
{
public:
	// RXgN^
	CPropertySheet(void);
	// fXgN^
	~CPropertySheet(void);
public:
	// 쐬
	INT_PTR	WINAPI Create (LPPROPSHEETHEADER  lpPsh);
	INT_PTR	WINAPI CreateA(LPPROPSHEETHEADERA lpPsh);
	INT_PTR	WINAPI CreateW(LPPROPSHEETHEADERW lpPsh);

	// 쐬
	template<int page>
	INT_PTR	WINAPI Create (LPPROPSHEETHEADER  lpPsh, ...)
	{
		HPROPSHEETPAGE hpsp[page];
		CPropertySheetPage* pPsp[page];
		va_list va;
		va_start(va, lpPsh);
		for( int i=0; i < page; ++i )
		{
			pPsp[i] = va_arg(va, CPropertySheetPage*);
			hpsp[i] = pPsp[i]->GetHandle();
		}
		lpPsh->dwFlags	&= ~PSH_PROPSHEETPAGE;
		lpPsh->nPages = page;
		lpPsh->phpage = hpsp;
		va_end(va);
		INT_PTR ret = Create(lpPsh);
		if( ret == -1 ) return ret;
		for( int i=0; i < page; ++i )
		{
			pPsp[i]->Detach();
		}
		return ret;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
