//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTabCtrl.h
 * @brief		^uRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXTabCtrl_H_
#define INCG_IRIS_WXTabCtrl_H_

//======================================================================
// include
#include "../app/WXSubClass.h"

//======================================================================
// declare
struct _IMAGELIST;
struct tagTCHITTESTINFO;
struct tagTCITEMA;
struct tagTCITEMW;

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CTabCtrl;

//======================================================================
// function
// ACȇ}
int		TabCtrl_InsertItemEx(HWND hWnd, int nItem, UINT unMask, LPTSTR lpszItem, int nImage, LPARAM lParam );
// `̈̎擾
int		TabCtrl_GetDrawRect(HWND hWnd, LPRECT lprc);
// `̈悩NCAg̈ɕϊ
int		TabCtrl_DrawToClientRect(HWND hWnd, LPRECT lprc);
// `̈悩EBhËɕϊ
int		TabCtrl_DrawToWindowRect(HWND hWnd, LPRECT lprc);

//======================================================================
// class
//! ^uRg[NX
class CTabCtrl : public CSubClass
{
public:
	// RXgN^
	CTabCtrl(void);
	CTabCtrl(HWND hWnd);
	// fXgN^
	~CTabCtrl(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND Create(DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );

protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// C[WXg̎擾
	struct _IMAGELIST*	GetImageList(void);
	// C[WXg̐ݒ
	struct _IMAGELIST*	SetImageList(struct _IMAGELIST* hImgList);
	// ACe̎擾
	int			GetItemCount(void);
#ifdef UNICODE
	// ACe̎擾
	BOOL		GetItem(int nItem, struct tagTCITEMW* pItem);
	// ACe̐ݒ
	BOOL		SetItem(int nItem, struct tagTCITEMW* pItem);
	// ACȇ}
	int			InsertItem(int nItem, const struct tagTCITEMW* pItem);
#else
	// ACe̎擾
	BOOL		GetItem(int nItem, struct tagTCITEMA* pItem);
	// ACe̐ݒ
	BOOL		SetItem(int nItem, struct tagTCITEMA* pItem);
	// ACȇ}
	int			InsertItem(int nItem, const struct tagTCITEMA* pItem);
#endif
	// ACȇ}
	int			InsertItem(int nItem, LPTSTR lpszItem );
	int			InsertItem(int nItem, LPTSTR lpszItem, int nImage );
	int			InsertItem(UINT unMask, int nItem, LPTSTR lpszItem, int nImage, LPARAM lParam );
	// ACe폜
	BOOL		DeleteItem(int nItem);
	// SACe폜
	BOOL		DeleteAllItems(void);
	// ACe̕\̈擾
	BOOL		GetItemRect(int nItem, LPRECT lprc);
	// J[\ʒu̎擾
	int			GetCurSel(void);
	// J[\ʒu̐ݒ
	int			SetCurSel(int nItem);
	// ̍W_Ƀ^uڂ邩eXg
	int			HitTest(tagTCHITTESTINFO* pInfo);
	// ^uڂɊ֘AÂf[^̃oCgݒ
	BOOL		SetItemExtra(void* pExItem);
	// EBhËƕ\̈̑ݕϊ
	int			AdjustRect(BOOL bLarger, LPRECT lprc);
	// ^u̕ƍݒ
	DWORD		SetItemSize(WORD x, WORD y);
	// C[WXg̃C[W폜
	void		RemoveImage(int nItem);
	// ^ũACRƃx̊ԂɊ蓖Ă̈̐ݒ
	void		SetPadding(WORD cx, WORD cy);
	// ^u̍s̎擾
	int			GetRowCount(void);
#if	!defined(IRIS_WIN32_WCE)
	// c[qg̃nh̎擾
	HWND		GetToolTips(void);
	// c[qg̊蓖
	void		SetToolTips(HWND hWndTT);
#endif
	// tH[JX̂^uڂ̎擾
	int			GetCurFocus(void);
	// ̃^uڂɃtH[JXݒ
	LRESULT		SetCurFocus(int nItem);
	// (_WIN32_IE >= 0x0300) !!-->>
	// ^u܂݂̍ŏݒ
	int			SetMinTabWidth(LPARAM x);
	// TCS_BUTTONS X^CɑIڂȂɂ
	void		DeselectAll(WPARAM fFocus);
	// <<--!! (_WIN32_IE >= 0x0300)
	// (_WIN32_IE >= 0x0400) !!-->>
	// ^uڂnCCg\
	BOOL		HighlightItem(int nItem, WORD fHighlight);
	// gX^Cݒ肷
	DWORD		SetExtendedStyle(DWORD dwExStyle);
	// gX^C擾
	DWORD		GetExtendedStyle(void);
#if	!defined(IRIS_WIN32_WCE)
	//
	BOOL		SetUnicodeFormat(BOOL Unicode);
	// 
	BOOL		GetUnicodeFormat(void);
#endif
	// <<--!! (_WIN32_IE >= 0x0400)
	// (_WIN32_IE >= 0x0500) !!-->>
	//
	BOOL		SetCCMVersion(DWORD dwVersion);
	// <<--!! (_WIN32_IE >= 0x0500)

	// `̈̎擾
	int			GetDrawRect(LPRECT lprc);
	// `̈悩NCAg̈ɕϊ
	int			DrawToClientRect(LPRECT lprc);
	// `̈悩EBhËɕϊ
	int			DrawToWindowRect(LPRECT lprc);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	
