//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRebar.h
 * @brief		o[Rg[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRebar_H_
#define INCG_IRIS_WXRebar_H_

//======================================================================
// include
#include "../../app/WXSubClass.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function
// RB_BEGINDRAG
void		Rebar_BeginDrag(HWND hWnd, UINT uIndex, DWORD dwPos);
// oh̍폜
BOOL		Rebar_DeleteBand(HWND hWnd, UINT uIndex);
// V}EXWw
void		Rebar_DragMove(HWND hWnd, DWORD dwPos);
// hbȌI
void		Rebar_EndDrag(HWND hWnd);
// ohE̎擾
void		Rebar_GetBandBorders(HWND hWnd, UINT uIndex, LPRECT lprc);
// oh̐擾
UINT		Rebar_GetBandCount(HWND hWnd);
// oh̎擾
BOOL		Rebar_GetBandInfo (HWND hWnd, UINT uIndex, LPREBARBANDINFO  lprbi);
BOOL		Rebar_GetBandInfoA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi);
BOOL		Rebar_GetBandInfoW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi);
// oh̃}[W擾
void		Rebar_GetBandMargins(HWND hWnd, LPARAM lpMargins);
// o[̍擾
UINT		Rebar_GetBarHeight(HWND hWnd);
// o[̏擾
BOOL		Rebar_GetBarInfo(HWND hWnd, LPREBARINFO lpri);
// wiF̎擾
COLORREF	Rebar_GetBkColor(HWND hWnd);
#if	!defined(IRIS_WIN32_WCE)
// Rg[̔zF擾
BOOL		Rebar_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
// RB_GETDROPTARGET
void		Rebar_GetDropTarget(HWND hWnd, IDropTarget** lpDropTarget);
#endif
// ݂̃pbg擾
HPALETTE	Rebar_GetPalette(HWND hWnd);
// oh̋E擾
BOOL		Rebar_GetRect(HWND hWnd, UINT uIndex, LPRECT lprc);
// oh̍s擾
UINT		Rebar_GetRowCount(HWND hWnd);
// oh̍擾
UINT		Rebar_GetRowHeight(HWND hWnd, UINT uIndex);
// eLXgF̎擾
COLORREF	Rebar_GetTextColor(HWND hWnd);
// c[`bvEBhE̎擾
HWND		Rebar_GetToolTips(HWND hWnd);
// RB_GETUNICODEFORMAT
BOOL		Rebar_GetUnicodeFormat(HWND hWnd);
// qbgeXg
int			Rebar_HitTest(HWND hWnd, LPRBHITTESTINFO lprhi);
// ohIDCfbNX擾
int			Rebar_IDToIndex(HWND hWnd, UINT uBandID);
// oh̑}
BOOL		Rebar_InsertBand (HWND hWnd, UINT uIndex, LPREBARBANDINFO  lprbi);
BOOL		Rebar_InsertBandA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi);
BOOL		Rebar_InsertBandW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi);
// ohő剻
void		Rebar_MaximizeBand(HWND hWnd, UINT uIndex, BOOL bIdel);
// ohŏ
void		Rebar_MinimizeBand(HWND hWnd, UINT uIndex);
// ohړ
BOOL		Rebar_MoveBand(HWND hWnd, UINT uFrom, UINT uTo);
// VFuvbV
void		Rebar_PushChevron(HWND hWnd, UINT uIndex, LPARAM lAppValue);
// oh̐ݒ
BOOL		Rebar_SetBandInfo (HWND hWnd, UINT uIndex, LPREBARBANDINFO  lprbi);
BOOL		Rebar_SetBandInfoA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi);
BOOL		Rebar_SetBandInfoW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi);
// o[̐ݒ
BOOL		Rebar_SetBarInfo(HWND hWnd, LPREBARINFO lpri);
// wiF̐ݒ
COLORREF	Rebar_SetBkColor(HWND hWnd, COLORREF color);
#if	!defined(IRIS_WIN32_WCE)
// Rg[̔zFݒ
void		Rebar_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
#endif
// pbg̐ݒ
HPALETTE	Rebar_SetPalette(HWND hWnd, HPALETTE hPalette);
// RB_SETPARENT
HWND		Rebar_SetParent(HWND hWnd, HWND hParent);
// eLXgF̐ݒ
COLORREF	Rebar_SetTextColor(HWND hWnd, COLORREF color);
// c[`bvEBhE̐ݒ
void		Rebar_SetToolTips(HWND hWnd, HWND hWndTT);
// RB_SETUNICODEFORMAT
BOOL		Rebar_SetUnicodeFormat(HWND hWnd, BOOL bUnicode);
// RB_SETWINDOWTHEME
LRESULT		Rebar_SetWindowTheme(HWND hWnd, WPARAM wParam, LPARAM lParam);
// oh̕\E\ݒ
BOOL		Rebar_ShowBand(HWND hWnd, UINT uIndex, BOOL bShow);
// RB_SIZETORECT
BOOL		Rebar_SizeToRect(HWND hWnd, LPRECT lprc);

//======================================================================
// class
//! o[(N[o[)Rg[NX
class CRebar : public CSubClass
{
public:
	// RXgN^
	CRebar(void);
	CRebar(HWND hWnd);
	// fXgN^
	~CRebar(void);

public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND Create(DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );

public:
	// RB_BEGINDRAG
	void		BeginDrag(UINT uIndex, DWORD dwPos);
	// oh̍폜
	BOOL		DeleteBand(UINT uIndex);
	// V}EXWw
	void		DragMove(DWORD dwPos);
	// hbȌI
	void		EndDrag(void);
	// ohE̎擾
	void		GetBandBorders(UINT uIndex, LPRECT lprc);
	// oh̐擾
	UINT		GetBandCount(void);
	// oh̎擾
	BOOL		GetBandInfo (UINT uIndex, LPREBARBANDINFO  lprbi);
	BOOL		GetBandInfoA(UINT uIndex, LPREBARBANDINFOA lprbi);
	BOOL		GetBandInfoW(UINT uIndex, LPREBARBANDINFOW lprbi);
	// oh̃}[W擾
	void		GetBandMargins(LPARAM lpMargins);
	// o[̍擾
	UINT		GetBarHeight(void);
	// o[̏擾
	BOOL		GetBarInfo(LPREBARINFO lpri);
	// wiF̎擾
	COLORREF	GetBkColor(void);
#if	 !defined(IRIS_WIN32_WCE)
	// Rg[̔zF擾
	BOOL		GetColorScheme(LPCOLORSCHEME lpClrScheme);
	// RB_GETDROPTARGET
	void		GetDropTarget(IDropTarget** lpDropTarget);
#endif
	// ݂̃pbg擾
	HPALETTE	GetPalette(void);
	// oh̋E擾
	BOOL		GetRect(UINT uIndex, LPRECT lprc);
	// oh̍s擾
	UINT		GetRowCount(void);
	// oh̍擾
	UINT		GetRowHeight(UINT uIndex);
	// eLXgF̎擾
	COLORREF	GetTextColor(void);
	// c[`bvEBhE̎擾
	HWND		GetToolTips(void);
	// RB_GETUNICODEFORMAT
	BOOL		GetUnicodeFormat(void);
	// qbgeXg
	int			HitTest(LPRBHITTESTINFO lprhi);
	// ohIDCfbNX擾
	int			IDToIndex(UINT uBandID);
	// oh̑}
	BOOL		InsertBand (UINT uIndex, LPREBARBANDINFO  lprbi);
	BOOL		InsertBandA(UINT uIndex, LPREBARBANDINFOA lprbi);
	BOOL		InsertBandW(UINT uIndex, LPREBARBANDINFOW lprbi);
	// ohő剻
	void		MaximizeBand(UINT uIndex, BOOL bIdel);
	// ohŏ
	void		MinimizeBand(UINT uIndex);
	// ohړ
	BOOL		MoveBand(UINT uFrom, UINT uTo);
	// VFuvbV
	void		PushChevron(UINT uIndex, LPARAM lAppValue);
	// oh̐ݒ
	BOOL		SetBandInfo (UINT uIndex, LPREBARBANDINFO  lprbi);
	BOOL		SetBandInfoA(UINT uIndex, LPREBARBANDINFOA lprbi);
	BOOL		SetBandInfoW(UINT uIndex, LPREBARBANDINFOW lprbi);
	// o[̐ݒ
	BOOL		SetBarInfo(LPREBARINFO lpri);
	// wiF̐ݒ
	COLORREF	SetBkColor(COLORREF color);
#if	 !defined(IRIS_WIN32_WCE)
	// Rg[̔zFݒ
	void		SetColorScheme(LPCOLORSCHEME lpClrScheme);
#endif
	// pbg̐ݒ
	HPALETTE	SetPalette(HPALETTE hPalette);
	// RB_SETPARENT
	HWND		SetParent(HWND hParent);
	// eLXgF̐ݒ
	COLORREF	SetTextColor(COLORREF color);
	// c[`bvEBhE̐ݒ
	void		SetToolTips(HWND hWndTT);
	// RB_SETUNICODEFORMAT
	BOOL		SetUnicodeFormat(BOOL bUnicode);
	// RB_SETWINDOWTHEME
	LRESULT		SetWindowTheme(WPARAM wParam, LPARAM lParam);
	// oh̕\E\ݒ
	BOOL		ShowBand(UINT uIndex, BOOL bShow);
	// RB_SIZETORECT
	BOOL		SizeToRect(LPRECT lprc);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
