//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackTrace.cpp
 * @brief		X^bNg[XNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStackTrace_CPP_

//======================================================================
// include
#include "WXStackTrace.h"
#include "../../base/WXError.h"
#include "WXDebugHelp.h"
#include <tchar.h>
#include "iris_debug.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// typedef
typedef BOOL (WINAPI *PFN_DuplicateHandle)(HANDLE hSourceProcessHandle, HANDLE hSourceHandle
	  , HANDLE hTargetProcessHandle, LPHANDLE lpTargetHandle, DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwOptions);
typedef BOOL (WINAPI *PFN_CloseHandle)(HANDLE hHandle);

//======================================================================
// struct
typedef struct tagTHREAD_ARGS
{
	CStackTrace*	pStackTrace;
	int				skip;
} THREAD_ARGS;

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStackTrace::CStackTrace(void)
: m_hCurrentProcess(nullptr)
{
	m_pfnDuplicateHandle = reinterpret_cast<PROC>(::DuplicateHandle);
	m_Info.filename[0] = TEXT('\0');
	m_Info.funcname[0] = TEXT('\0');
	m_Info.line = -1;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStackTrace::~CStackTrace(void)
{
}

/**********************************************************************//**
 *
 * g[X
 *
*//***********************************************************************/
bool CStackTrace::Trace(int skip)
{
	IRIS_ASSERT( m_hCurrentProcess == nullptr );
	IRIS_ASSERT( !m_Thread.IsValid() );

	HANDLE hProcess = ::GetCurrentProcess();
	HANDLE hThreadTmp = ::GetCurrentThread();
	HANDLE hThread = nullptr;

	if( !reinterpret_cast<PFN_DuplicateHandle>(*m_pfnDuplicateHandle)(hProcess, hThreadTmp, hProcess, &hThread, 0 , FALSE , DUPLICATE_SAME_ACCESS) )
	{
		return false;
	}
	m_hCurrentProcess = hProcess;
	m_CurrentThread.Attach(hThread);

	THREAD_ARGS args = { this, skip };
	m_Thread.CreateStart((PROC)_Entry, &args);

	DWORD dwExitCode = m_Thread.Wait();

	m_Thread.Close();
	m_CurrentThread.Close();
	m_hCurrentProcess = nullptr;

	return dwExitCode == 0;
}

/**********************************************************************//**
 *
 * g[Xs
 *
*//***********************************************************************/
bool CStackTrace::Search(int skip)
{
	HANDLE hProcess = ::GetCurrentProcess();
	CONTEXT thCntx = {0};
	thCntx.ContextFlags = CONTEXT_FULL;
	IRIS_ASSERT( m_CurrentThread != nullptr );
#if 0
#if defined(_M_IX86)
    __asm    call(x);
    __asm x: pop eax;
    __asm    mov thCntx.Eip, eax;
    __asm    mov thCntx.Ebp, ebp;
    __asm    mov thCntx.Esp, esp;
#else
    RtlCaptureContext(&context);
#endif

#else
	if( !::GetThreadContext(m_CurrentThread, &thCntx) )
	{
		IRIS_ASSERT(0);
		return false;
	}
#endif

	STACKFRAME stackFrame = {0};
#if		defined(_M_IX86)
	stackFrame.AddrPC.Offset    = thCntx.Eip;
	stackFrame.AddrStack.Offset = thCntx.Esp;
	stackFrame.AddrFrame.Offset = thCntx.Ebp;
#elif	defined(_M_AMD64)
	stackFrame.AddrPC.Offset    = thCntx.Rip;
	stackFrame.AddrStack.Offset = thCntx.Rsp;
	stackFrame.AddrFrame.Offset = thCntx.Rbp;
#elif	defined(_M_IA64)
	stackFrame.AddrPC.Offset    = thCntx.StIIP;
	stackFrame.AddrStack.Offset = thCntx.IntSp;
	stackFrame.AddrFrame.Offset = thCntx.RsBSP;
#else
	stackFrame.AddrPC.Offset    = thCntx.Eip;
	stackFrame.AddrStack.Offset = thCntx.Esp;
	stackFrame.AddrFrame.Offset = thCntx.Ebp;
#endif

	stackFrame.AddrPC.Mode      = AddrModeFlat;
	stackFrame.AddrStack.Mode   = AddrModeFlat;
	stackFrame.AddrFrame.Mode   = AddrModeFlat;
	stackFrame.AddrReturn.Mode  = AddrModeFlat;
	stackFrame.AddrBStore.Mode  = AddrModeFlat;

	CSymbol symbol(m_hCurrentProcess);
	bool ret = false;
#if		defined(_M_IX86)
	DWORD machineType = IMAGE_FILE_MACHINE_I386;
#elif	defined(_M_AMD64)
	DWORD machineType = IMAGE_FILE_MACHINE_AMD64;
#elif	defined(_M_IA64)
	DWORD machineType = IMAGE_FILE_MACHINE_IA64;
#else
	DWORD machineType = IMAGE_FILE_MACHINE_UNKNOWN;
#endif
	while(skip)
	{
		if( !::StackWalk(machineType
			, m_hCurrentProcess, m_CurrentThread
			, &stackFrame, &thCntx, nullptr
			, ::SymFunctionTableAccess, ::SymGetModuleBase, nullptr) )
		{
			break;
		}

		if(stackFrame.AddrPC.Offset == stackFrame.AddrReturn.Offset)
		{
			// GhXɂȂ̂ŏI
			break;
		}
		if(stackFrame.AddrPC.Offset == 0)
		{
			// sȃX^bNt[
			break;
		}       
		if(stackFrame.AddrReturn.Offset == 0)
		{
			// Ō̃X^bNt[
			break;
		}

		// W[̎擾
		IMAGEHLP_MODULE ihm = { sizeof(IMAGEHLP_MODULE), };
		if( !symbol.GetModuleInfo(stackFrame.AddrPC.Offset, &ihm) )
		{
			continue;
		}

		// ֐̎擾
#define USE_IMAGEHLP_SYMBOL
#if	defined(USE_IMAGEHLP_SYMBOL)
#  define SYMINFO	IMAGEHLP_SYMBOL
#else	 
#  define SYMINFO	SYMBOL_INFO	
#endif
		SYMINFO* pSymbol = nullptr;
		u8 buffer[sizeof(SYMINFO) + MAX_SYM_NAME * sizeof(TCHAR)] = {0};
		pSymbol = reinterpret_cast<SYMINFO*>(buffer);
		pSymbol->SizeOfStruct = sizeof(SYMINFO);
#if	defined(USE_IMAGEHLP_SYMBOL)
		pSymbol->MaxNameLength = MAX_SYM_NAME;
#else
		pSymbol->MaxNameLen = MAX_SYM_NAME;
#endif

		if( !symbol.GetSymFromAddr(stackFrame.AddrPC.Offset, nullptr, (PIMAGEHLP_SYMBOL)pSymbol) )
		{
			pSymbol->Name[0] = '\0';
		}

		// sԍ̎擾
		IMAGEHLP_LINE line = { sizeof(IMAGEHLP_LINE) };

		if( !symbol.GetLineFromAddr(stackFrame.AddrPC.Offset, nullptr, &line) ) 
		{
			line.FileName = nullptr;
		}

		--skip;
		if( skip == 0 )
		{
#ifdef UNICODE
			size_t ret;
			mbstowcs_s(&ret, m_Info.funcname, MAX_PATH, pSymbol->Name, _TRUNCATE);
#else
			_tcsncpy_s(m_Info.funcname, MAX_PATH, pSymbol->Name, _TRUNCATE);
#endif
			if( line.FileName != nullptr )
			{
#ifdef UNICODE
				mbstowcs_s(&ret, m_Info.filename, MAX_PATH, line.FileName, _TRUNCATE);
#else
				_tcscpy_s(m_Info.filename, MAX_PATH, line.FileName);
#endif
			}
			else
			{
				m_Info.filename[0] = TEXT('\0');
			}
			m_Info.funcname[MAX_PATH-1] = TEXT('\0');
			m_Info.line = line.LineNumber;
			ret = true;
			break;
		}
	}
	symbol.Detach();
	return ret;
}

/**********************************************************************//**
 *
 * Gg
 *
*//***********************************************************************/
UINT CStackTrace::Entry(int skip)
{
	// ΏۃXbh~
	m_CurrentThread.Suspend();

	// g[Xs
	bool ret = Search(skip);

	// ΏۃXbh𕜋A
	m_CurrentThread.Resume();

	return ret ? 0 : 1;
}

/**********************************************************************//**
 *
 * Gg
 *
 -----------------------------------------------------------------------
 * @param [in]	pUser	= THREAD_ARGS*
 * @return	
*//***********************************************************************/
UINT WINAPI CStackTrace::_Entry(void* pUser)
{
	IRIS_ASSERT( pUser != nullptr );
	THREAD_ARGS* args = reinterpret_cast<THREAD_ARGS*>(pUser);
	CStackTrace* p = args->pStackTrace;
	return p->Entry(args->skip);
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris
