//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPlugin.cpp
 * @brief		vOCNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPlugin_CPP_

//======================================================================
// inculde
#include "WXPlugin.h"
#include "../../io/WXFindFile.h"
#include "../../os/WXModule.h"
#include "iris_debug.h"
#include <tchar.h>

#ifdef _IRIS_DEBUG
#include "../../base/WXError.h"
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
// ftHgCX^Xj֐
void WINAPI DefaultDeletePluginInstance(iris::wx::IPluginBase* lpPlugin);

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPluginManegr::CPluginManegr(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPluginManegr::~CPluginManegr(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CPluginManegr::Initialize(void)
{
	CFindFile find;
	if( find.FindFirst(IRIS_TEXT("./*.dll")) )
	{
		do
		{
			LoadPulgin(find.cFileName);
		} while( find.FindNext() );
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPluginManegr::Release(void)
{
	// Sĉ
	PluginMap::iterator it = m_Plugins.begin();
	while( it != m_Plugins.end() )
	{
		IRIS_VERIFY( UnloadPulgin(it->first) );
		it = m_Plugins.begin();
	}
}

/**********************************************************************//**
 *
 * vOCdll̓Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in] fname	= dll̃pX
 * @return	vOCID
 * @retval	0 = s
*//***********************************************************************/
s32 CPluginManegr::LoadPulgin(LPCTSTR fname)
{
	if( fname == nullptr ) return 0;
	CModule module;
	if( !module.Load(fname) ) return 0;
	
	typedef IPluginBase* __stdcall pfnCreateInstance(void);	// CX^X֐|C^
	pfnCreateInstance* CreateInstance = nullptr;
	CreateInstance = reinterpret_cast<pfnCreateInstance*>(GetProcAddress(module, "_CreatePluginInstance@0"));
	if( CreateInstance == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		CLastError es(0);
		es = CScopedLastError();
		_tprintf(es.ToString());
#endif
		return 0;
	}

	IPluginBase* pPlugin = (CreateInstance)();
	if( pPlugin == nullptr ) return 0;
	s32 id = m_UID.Create();
	pPlugin->m_ID = id;
	IRIS_ASSERT( m_Plugins.find(id) == m_Plugins.end() );

	m_Plugins.insert(PluginPair(id, pPlugin));
	m_Modules.insert(ModulePair(id, module));
	module.Detach();	// Ȃ悤

	if( !pPlugin->OnCreate() ) 
	{
		UnloadPulgin(id);
		return 0;
	}
	return id;
}

/**********************************************************************//**
 *
 * vOC̉
 *
 ----------------------------------------------------------------------
 * @param [in] id	= vOCID
 * @return	
*//***********************************************************************/
bool CPluginManegr::UnloadPulgin(u32 id)
{
	PluginMap::iterator p = m_Plugins.find(id);
	if( p == m_Plugins.end() ) return false;
	if( p->first != id ) return false;

	ModuleMap::iterator m = m_Modules.find(id);
	if( m == m_Modules.end() ) return false;
	if( m->first != id ) return false;

	typedef void __stdcall pfnDeleteInstance(IPluginBase*);	// CX^Xj֐|C^
	pfnDeleteInstance* DeleteInstance = nullptr;
	DeleteInstance = reinterpret_cast<pfnDeleteInstance*>(GetProcAddress(m->second, "_DeletePluginInstance@4"));
	if( DeleteInstance == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		CLastError es(0);
		es = CScopedLastError();
		_tprintf(es.ToString());
#endif
		IRIS_WARNING("GetProcAddress \"DeletePluginInstance\" was failed.");
		DeleteInstance = DefaultDeletePluginInstance;
	}

	p->second->OnDelete();
	DeleteInstance(p->second);
	FreeLibrary(m->second);

	m_Plugins.erase(id);
	m_Modules.erase(id);
	m_UID.Delete(id);
	return true;
}

/**********************************************************************//**
 *
 * vOCmapiterator擾
 *
 ----------------------------------------------------------------------
 * @return	vOCmapiterator
*//***********************************************************************/
CPluginManegr::iterator CPluginManegr::begin(void)
{
	return m_Plugins.begin();
}

/**********************************************************************//**
 *
 * vOCmapiterator擾
 *
 ----------------------------------------------------------------------
 * @return	vOCmapiterator
*//***********************************************************************/
CPluginManegr::iterator CPluginManegr::end(void)
{
	return m_Plugins.end();
}

//======================================================================
// function
/**********************************************************************//**
 *
 * ftHgCX^Xj֐
 *
 ----------------------------------------------------------------------
 * @return	vOCNXCX^X
*//***********************************************************************/
void WINAPI DefaultDeletePluginInstance(iris::wx::IPluginBase* lpPlugin)
{
	delete lpPlugin;
}

}	// end of namespace wx
}	// end of namespace iris
