//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBitmap.cpp
 * @brief		HBITMAPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiBitmap_CPP_

//======================================================================
// include
#include "WXGdiBitmap.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	nWidth		= 
 * @param [in]	nHeight		= 
 * @param [in]	uPlanes		= J[v[
 * @param [in]	nBitCount	= rbg[x
 * @param [in]	lpBits		= sNZf[^
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::Create(int nWidth, int nHeight, UINT uPlanes, UINT nBitCount, const void* lpBits)
{
	HBITMAP hBmp = CreateBitmap(nWidth, nHeight, uPlanes, nBitCount, lpBits);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpbmp		= rbg}bv
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateIndirect(const LPBITMAP lpbmp)
{
	if( lpbmp == nullptr ) return FALSE;
#if	!defined(IRIS_WIN32_WCE)
	HBITMAP hBmp = CreateBitmapIndirect(lpbmp);
#else
	HBITMAP hBmp = CreateBitmap(lpbmp->bmWidth, lpbmp->bmHeight, lpbmp->bmPlanes, lpbmp->bmBitsPixel, lpbmp->bmBits);
#endif
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	lpbih	= rbg}bṽf[^
 * @param [in]	dwInit	= IvV
 * @param [in]	pjBits	= f[^
 * @param [in]	lpbmi	= rbg}bv
 * @param [in]	Usage	= F̎gp@B(DIB_***)
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateDIB(HDC hdc, const LPBITMAPINFOHEADER lpbih, DWORD dwInit, const void* pjBits, const LPBITMAPINFO lpbmi, UINT Usage)
{
	HBITMAP hBmp = CreateDIBitmap(hdc, lpbih, dwInit, pjBits, lpbmi, Usage);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	lpbmi		= rbg}bv
 * @param [in]	Usage		= F̎gp@B(DIB_***)
 * @param [out]	ppvBits		= óBDIBrbgl
 * @param [in]	hSection	= t@C}bsOIuWFNg(nullptr)
 * @param [in]	offset		= t@C}bsOIuWFNg̃ItZbg
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateDIBSection(HDC hdc, const LPBITMAPINFO lpbmi, UINT Usage, void** ppvBits, HANDLE hSection, DWORD offset)
{
	HBITMAP hBmp = ::CreateDIBSection(hdc, lpbmi, Usage, ppvBits, hSection, offset);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̓ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	lpBitmapName	= rbg}bv
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::Load (HINSTANCE hInstance, LPCTSTR lpBitmapName)
{
#ifdef UNICODE
	return LoadW(hInstance, lpBitmapName);
#else
	return LoadA(hInstance, lpBitmapName);
#endif
}
/// CGDIBitmap::Load Q
BOOL CGDIBitmap::LoadA(HINSTANCE hInstance, LPCSTR  lpBitmapName)
{
	HBITMAP hBmp = ::LoadBitmapA(hInstance, lpBitmapName);
	return TryAttach(hBmp);
}
/// CGDIBitmap::Load Q
BOOL CGDIBitmap::LoadW(HINSTANCE hInstance, LPCWSTR lpBitmapName)
{
	HBITMAP hBmp = ::LoadBitmapW(hInstance, lpBitmapName);
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * foCXReLXgɊ֘AtĂrbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	cx		= 
 * @param [in]	cy		= 
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateCompatible(HDC hdc, int cx, int cy)
{
	HBITMAP hBmp = CreateCompatibleBitmap(hdc, cx, cy);
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBmp	= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::GetBitmapInfo(LPBITMAP lpBmp)
{
	return GetObject(lpBmp, sizeof(BITMAP)) ? TRUE : FALSE;
}

/**********************************************************************//**
 *
 * f[^̕ύX
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	uStart		= ύX̊JnC
 * @param [in]	uLines		= ύX郉C
 * @param [in]	lpBits		= rbg
 * @param [in]	lpbmi		= rbg}bv
 * @param [in]	ColorUse	= J[CfbNX̎
 * @return	
*//***********************************************************************/
int CGDIBitmap::SetDIBits(HDC hdc, UINT uStart, UINT uLines, const void* lpBits, const LPBITMAPINFO lpbmi, UINT ColorUse)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::SetDIBits(hdc, m_hObj, uStart, uLines, lpBits, lpbmi, ColorUse);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * f[^̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	uStart		= ύX̊JnC
 * @param [in]	uLines		= ύX郉C
 * @param [out]	lpBits		= rbg
 * @param [out]	lpbmi		= rbg}bv
 * @param [in]	Usage		= F̎gp@B(DIB_***)
 * @return	
*//***********************************************************************/
int CGDIBitmap::GetDIBits(HDC hdc, UINT uStart, UINT uLines, LPVOID lpBits, LPBITMAPINFO lpbmi, UINT Usage)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::GetDIBits(hdc, m_hObj, uStart, uLines, lpBits, lpbmi, Usage);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * rbg}bṽTCY擾
 *
 * @note	擾Ώۂ̃TCÝA SetDimensionEx ֐gĐݒ肵̂łȂ΂Ȃ܂
 *
 -----------------------------------------------------------------------
 * @param [out]	lpSize		= o
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::GetDimensionEx(LPSIZE lpSize)
{
#if	!defined(IRIS_WIN32_WCE)
	return GetBitmapDimensionEx(m_hObj, lpSize);
#else
	IRIS_UNUSED_VARIABLE(lpSize);
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * rbg}bṽTCYݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	nWidth	= (0.01mmP)
 * @param [in]	nHeight	= (0.01mmP)
 * @param [out]	lpSize	= ̃TCY(nullptr)
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::SetDimensionEx(int nWidth, int nHeight, LPSIZE lpSize)
{
#if	!defined(IRIS_WIN32_WCE)
	return SetBitmapDimensionEx(m_hObj, nWidth, nHeight, lpSize);
#else
	IRIS_UNUSED_VARIABLE(nWidth);
	IRIS_UNUSED_VARIABLE(nHeight);
	IRIS_UNUSED_VARIABLE(lpSize);
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris
