//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBitmap.h
 * @brief		HBITMAPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXGdiBitmap_H_
#define INCG_IRIS_WXGdiBitmap_H_

//======================================================================
// include
#include "WXGdiObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! HBITMAPNX
class CGDIBitmap : public CGDIObjectBase<HBITMAP>
{
	typedef CGDIObjectBase<HBITMAP>	_Mybase;
public:
	// RXgN^
	CGDIBitmap(void) {}

#ifdef STRICT
	// ^̌ɑΉ
	/// RXgN^
	CGDIBitmap(HGDIOBJ hObj) : _Mybase(static_cast<_MyObj>(hObj)) 		{}
				operator	HGDIOBJ (void)		{ return static_cast<HGDIOBJ>(GetHandle()); }
	CGDIBitmap&	operator	= (HGDIOBJ hObj)	{ Attach(static_cast<_MyObj>(hObj)); return *this; }
#endif

public:
	// rbg}bv̍쐬
	BOOL		Create(int nWidth, int nHeight, UINT uPlanes, UINT nBitCount, const void* lpBits);
	// rbg}bv̍쐬
	BOOL		CreateIndirect(const LPBITMAP lpbmp);
	// rbg}bv̍쐬
	BOOL		CreateDIB(HDC hdc, const LPBITMAPINFOHEADER lpbih, DWORD dwInit, const void* pjBits, const LPBITMAPINFO lpbmi, UINT Usage);
	// AvP[V璼ڏ݉\ȃrbg}bv̍쐬
	BOOL		CreateDIBSection(HDC hdc, const LPBITMAPINFO lpbmi, UINT Usage, void** ppvBits, HANDLE hSection, DWORD offset);
	// foCXReLXgɊ֘AtĂrbg}bv̍쐬
	BOOL		CreateCompatible(HDC hdc, int cx, int cy);

	// rbg}bv̓ǂݍ
	BOOL		Load (HINSTANCE hInstance, LPCTSTR lpBitmapName);
	BOOL		LoadA(HINSTANCE hInstance, LPCSTR  lpBitmapName);
	BOOL		LoadW(HINSTANCE hInstance, LPCWSTR lpBitmapName);

	// rbg}bv̎擾
	BOOL		GetBitmapInfo(LPBITMAP lpBmp);

public:
	// f[^̕ύX
	int			SetDIBits(HDC hdc, UINT uStart, UINT uLines, const void* lpBits, const LPBITMAPINFO lpbmi, UINT ColorUse);
	// f[^̎擾
	int			GetDIBits(HDC hdc, UINT uStart, UINT uLines, LPVOID lpBits, LPBITMAPINFO lpbmi, UINT Usage);

public:
	// rbg}bṽTCY擾
	BOOL		GetDimensionEx(LPSIZE lpSize);
	// rbg}bṽTCYݒ
	BOOL		SetDimensionEx(int nWidth, int nHeight, LPSIZE lpSize);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
