//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBrush.h
 * @brief		GDIuVIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXGdiBrush_H_
#define INCG_IRIS_WXGdiBrush_H_

//======================================================================
// include
#include "WXGdiObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! GDIuVIuWFNgNX
class CGDIBrush : public CGDIObjectBase<HBRUSH>
{
	typedef CGDIObjectBase<HBRUSH>	_Base;
public:
	// RXgN^
	CGDIBrush(void)	{}

#ifdef STRICT
	// ^̌ɑΉ
	/// RXgN^
	CGDIBrush(HGDIOBJ hObj) : _Base(static_cast<_MyObj>(hObj)) 		{}
				operator	HGDIOBJ (void)		{ return static_cast<HGDIOBJ>(GetHandle()); }
	CGDIBrush&	operator	= (HGDIOBJ hObj)	{ Attach(static_cast<_MyObj>(hObj)); return *this; }
#endif

public:
	// uV̍쐬
	BOOL	CreateSolid(COLORREF color);
	BOOL	CreateHatch(int nHatch, COLORREF color);

	BOOL	Create(UINT nStyle, ULONG_PTR Hatch, COLORREF color);
	BOOL	Create(const PLOGBRUSH lppen);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
