//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiFont.h
 * @brief		GDItHgIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiFont_CPP_

//======================================================================
// include
#include "WXGdiFont.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIFont
/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nHeight			= 
 * @param [in]	nWidth			= 
 * @param [in]	nEscapement		= 
 * @param [in]	nOrientation	= 
 * @param [in]	nWeight			= 
 * @param [in]	bItalic			= 
 * @param [in]	bUnderline		= 
 * @param [in]	bStrikeOut		= 
 * @param [in]	iCharSet		= 
 * @param [in]	iOutPrecision	= 
 * @param [in]	iClipPrecision	= 
 * @param [in]	iQuality		= 
 * @param [in]	iPitchAndFamily	= 
 * @param [in]	pszFaceName		= 
 * @return	
*//***********************************************************************/
BOOL CGDIFont::Create (int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCTSTR  pszFaceName)
{
#ifdef UNICODE
	return CreateW(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
#else
	return CreateA(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
#endif
}
/// CGDIFont::Create Q
BOOL CGDIFont::CreateA(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCSTR  pszFaceName)
{
	HFONT hFont = CreateFontA(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	return TryAttach(hFont);
}
/// CGDIFont::Create Q
BOOL CGDIFont::CreateW(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName)
{
	HFONT hFont = CreateFontW(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	return TryAttach(hFont);
}

/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
BOOL CGDIFont::CreateIndirect (const LOGFONT*  lplf)
{
#ifdef UNICODE
	return CreateIndirectW(lplf);
#else
	return CreateIndirectA(lplf);
#endif
}
/// CGDIFont::CreateIndirect Q
BOOL CGDIFont::CreateIndirectA(const LOGFONTA* lplf)
{
	HFONT hFont = CreateFontIndirectA(lplf);
	return TryAttach(hFont);
}
/// CGDIFont::CreateIndirect Q
BOOL CGDIFont::CreateIndirectW(const LOGFONTW* lplf)
{
	HFONT hFont = CreateFontIndirectW(lplf);
	return TryAttach(hFont);
}

}	// end of namespace wx
}	// end of namespace iris
