//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPaintStruct.cpp
 * @brief		PAINTSTRUCT t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPaintStruct_CPP_

//======================================================================
// include
#include "WXPaintStruct.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPaintStruct::CPaintStruct(void)
: m_hWnd(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CPaintStruct::CPaintStruct(HWND hWnd)
: m_hWnd(nullptr)
{
	Begin(hWnd);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC	= foCXReLXg
*//***********************************************************************/
CPaintStruct::CPaintStruct(HDC hDC)
: m_hWnd(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPaintStruct::~CPaintStruct(void)
{
	if( m_hDC == m_Paint.hdc ) Detach();	// DeleteDCȂ
	End();
}

/**********************************************************************//**
 *
 * Jn
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @return	foCXReLXg
*//***********************************************************************/
HDC CPaintStruct::Begin(HWND hWnd)
{
	HDC hdc = BeginPaint(hWnd, &m_Paint);
	if( hdc == nullptr ) return nullptr;
	m_hWnd = hWnd;
	//Attach(hdc);	// attachƎs邩Ȃ̂
	m_hDC = hdc;
	return hdc;
}

/**********************************************************************//**
 *
 * I
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPaintStruct::End(void)
{
	//if( m_hWnd == nullptr ) return TRUE;	// JnĂȂƔf
	HDC hdc = m_Paint.hdc;
	if( !EndPaint(m_hWnd, &m_Paint) ) return FALSE;
	m_hWnd = nullptr;
	if( m_hDC == hdc )	m_hDC = nullptr;
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
